/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.msg.request;

import com.invertor.modbus.data.DataHolder;
import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.msg.base.ModbusRequest;
import com.invertor.modbus.msg.base.ModbusResponse;
import com.invertor.modbus.msg.response.IllegalFunctionResponse;
import com.invertor.modbus.net.stream.base.ModbusInputStream;
import com.invertor.modbus.net.stream.base.ModbusOutputStream;
import java.io.IOException;

public class IllegalFunctionRequest
extends ModbusRequest {
    private final int functionCode;

    public IllegalFunctionRequest(int serverAddress, int functionCode) throws ModbusNumberException {
        super(serverAddress);
        this.functionCode = functionCode;
    }

    public void writeRequest(ModbusOutputStream fifo) throws IOException {
        throw new IOException("Can't send Illegal request");
    }

    public int requestSize() {
        return 0;
    }

    public ModbusResponse process(DataHolder dataHolder) throws ModbusNumberException {
        return new IllegalFunctionResponse(this.getServerAddress(), this.getFunction());
    }

    protected boolean validateResponseImpl(ModbusResponse response) {
        return response.getFunction() == this.getFunction();
    }

    public void readPDU(ModbusInputStream fifo) throws ModbusNumberException, IOException {
    }

    public int getFunction() {
        return this.functionCode;
    }
}

