/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.msg.request;

import com.invertor.modbus.data.CommStatus;
import com.invertor.modbus.data.DataHolder;
import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.msg.base.ModbusRequest;
import com.invertor.modbus.msg.base.ModbusResponse;
import com.invertor.modbus.msg.response.GetCommEventLogResponse;
import com.invertor.modbus.net.stream.base.ModbusInputStream;
import com.invertor.modbus.net.stream.base.ModbusOutputStream;
import com.invertor.modbus.utils.ModbusFunctionCode;
import java.io.IOException;

public final class GetCommEventLogRequest
extends ModbusRequest {
    public GetCommEventLogRequest(int serverAddress) throws ModbusNumberException {
        super(serverAddress);
    }

    public void writeRequest(ModbusOutputStream fifo) throws IOException {
    }

    public int requestSize() {
        return 0;
    }

    public ModbusResponse process(DataHolder dataHolder) throws ModbusNumberException {
        GetCommEventLogResponse response = new GetCommEventLogResponse(this.getServerAddress());
        CommStatus commStatus = dataHolder.getCommStatus();
        response.setEventCount(commStatus.getEventCount());
        response.setStatus(commStatus.getCommStatus());
        response.setMessageCount(commStatus.getMessageCount());
        response.setEvents(commStatus.getEventLog());
        return response;
    }

    public boolean validateResponseImpl(ModbusResponse response) {
        return true;
    }

    public void readPDU(ModbusInputStream fifo) throws ModbusNumberException, IOException {
    }

    public int getFunction() {
        return ModbusFunctionCode.GET_COMM_EVENT_LOG.toInt();
    }
}

