/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.msg.request;

import com.invertor.modbus.data.DataHolder;
import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.exception.ModbusProtocolException;
import com.invertor.modbus.msg.base.ModbusRequest;
import com.invertor.modbus.msg.base.ModbusResponse;
import com.invertor.modbus.msg.base.mei.MEIFactory;
import com.invertor.modbus.msg.base.mei.ModbusEncapsulatedInterface;
import com.invertor.modbus.msg.response.EncapsulatedInterfaceTransportResponse;
import com.invertor.modbus.net.stream.base.ModbusInputStream;
import com.invertor.modbus.net.stream.base.ModbusOutputStream;
import com.invertor.modbus.utils.MEITypeCode;
import com.invertor.modbus.utils.ModbusFunctionCode;
import java.io.IOException;

public class EncapsulatedInterfaceTransportRequest
extends ModbusRequest {
    private ModbusEncapsulatedInterface mei = null;

    public EncapsulatedInterfaceTransportRequest(int serverAddress) throws ModbusNumberException {
        super(serverAddress);
    }

    public void setMEIType(MEITypeCode meiTypeCode) {
        this.setMei(MEIFactory.getMEI(meiTypeCode));
    }

    public void writeRequest(ModbusOutputStream fifo) throws IOException {
        fifo.write(this.mei.getTypeCode().toInt());
        this.mei.writeRequest(fifo);
    }

    public void readPDU(ModbusInputStream fifo) throws ModbusNumberException, IOException {
        int meiTypeCode = fifo.read();
        this.mei = MEIFactory.getMEI(MEITypeCode.get(meiTypeCode));
        if (this.mei == null) {
            throw new ModbusNumberException("Unknown MEI type", meiTypeCode);
        }
        this.mei.readRequest(fifo);
    }

    public int requestSize() {
        return 1 + (this.mei == null ? 0 : this.mei.getRequestSize());
    }

    public ModbusResponse process(DataHolder dataHolder) throws ModbusNumberException {
        EncapsulatedInterfaceTransportResponse response = new EncapsulatedInterfaceTransportResponse(this.getServerAddress());
        response.setMei(this.mei);
        try {
            response.getMei().process(dataHolder);
        }
        catch (ModbusProtocolException e) {
            response.setException();
            response.setModbusExceptionCode(e.getException().getValue());
        }
        return response;
    }

    public ModbusEncapsulatedInterface getMei() {
        return this.mei;
    }

    public void setMei(ModbusEncapsulatedInterface mei) {
        this.mei = mei;
    }

    protected boolean validateResponseImpl(ModbusResponse response) {
        if (!(response instanceof EncapsulatedInterfaceTransportResponse)) {
            return false;
        }
        return this.mei.getTypeCode() == ((EncapsulatedInterfaceTransportResponse)response).getMei().getTypeCode();
    }

    public int getFunction() {
        return ModbusFunctionCode.ENCAPSULATED_INTERFACE_TRANSPORT.toInt();
    }
}

