/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.msg.request;

import com.invertor.modbus.data.CommStatus;
import com.invertor.modbus.data.DataHolder;
import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.msg.base.ModbusRequest;
import com.invertor.modbus.msg.base.ModbusResponse;
import com.invertor.modbus.msg.response.DiagnosticsResponse;
import com.invertor.modbus.net.stream.base.ModbusInputStream;
import com.invertor.modbus.net.stream.base.ModbusOutputStream;
import com.invertor.modbus.utils.DiagnosticsSubFunctionCode;
import com.invertor.modbus.utils.ModbusFunctionCode;
import java.io.IOException;

public class DiagnosticsRequest
extends ModbusRequest {
    public static final int CLEAR_LOG = 65280;
    private DiagnosticsSubFunctionCode subFunctionCode = DiagnosticsSubFunctionCode.RESERVED;
    private int subFunctionData = 0;

    public DiagnosticsRequest(int serverAddress) throws ModbusNumberException {
        super(serverAddress);
    }

    public void writeRequest(ModbusOutputStream fifo) throws IOException {
        fifo.writeShortBE(this.getSubFunctionCode().toInt());
        fifo.writeShortBE(this.getSubFunctionData());
    }

    public int requestSize() {
        return 4;
    }

    public ModbusResponse process(DataHolder dataHolder) throws ModbusNumberException {
        DiagnosticsResponse response = new DiagnosticsResponse(this.getServerAddress());
        response.setSubFunctionCode(this.getSubFunctionCode());
        CommStatus commStatus = dataHolder.getCommStatus();
        switch (this.getSubFunctionCode()) {
            case RETURN_QUERY_DATA: {
                response.setSubFunctionData(this.getSubFunctionData());
                break;
            }
            case RESTART_COMMUNICATIONS_OPTION: {
                if (this.getSubFunctionData() == 65280) {
                    commStatus.setClearLog(true);
                }
                commStatus.setRestartCommunicationsOption(true);
                response.setSubFunctionData(this.getSubFunctionData());
                break;
            }
            case RETURN_DIAGNOSTIC_REGISTER: {
                response.setSubFunctionData(commStatus.getDiagnosticRegister());
                break;
            }
            case CHANGE_ASCII_INPUT_DELIMITER: {
                commStatus.setAsciiInputDelimiter(this.getSubFunctionData() >> 8 & 0xFF);
                response.setSubFunctionData(this.getSubFunctionData());
                break;
            }
            case FORCE_LISTEN_ONLY_MODE: {
                commStatus.setListenOnlyMode(true);
                break;
            }
            case CLEAR_COUNTERS_AND_DIAGNOSTIC_REGISTER: {
                commStatus.clearCountersAndDiagnosticRegister();
                response.setSubFunctionData(this.getSubFunctionData());
                break;
            }
            case RETURN_BUS_MESSAGE_COUNT: {
                response.setSubFunctionData(commStatus.getMessageCount());
                break;
            }
            case RETURN_BUS_COMMUNICATION_ERROR_COUNT: {
                response.setSubFunctionData(commStatus.getCommunicationErrorCount());
                break;
            }
            case RETURN_BUS_EXCEPTION_ERROR_COUNT: {
                response.setSubFunctionData(commStatus.getExceptionErrorCount());
                break;
            }
            case RETURN_SLAVE_MESSAGE_COUNT: {
                response.setSubFunctionData(commStatus.getSlaveMessageCount());
                break;
            }
            case RETURN_SLAVE_NO_RESPONSE_COUNT: {
                response.setSubFunctionData(commStatus.getSlaveNoResponseCount());
                break;
            }
            case RETURN_SLAVE_NAK_COUNT: {
                response.setSubFunctionData(commStatus.getSlaveNAKCount());
                break;
            }
            case RETURN_SLAVE_BUSY_COUNT: {
                response.setSubFunctionData(commStatus.getSlaveBusyCount());
                break;
            }
            case RETURN_BUS_CHARACTER_OVERRUN_COUNT: {
                response.setSubFunctionData(commStatus.getCharacterOverrunCount());
                break;
            }
            case CLEAR_OVERRUN_COUNTER_AND_FLAG: {
                commStatus.setCharacterOverrunCount(0);
                response.setSubFunctionData(this.getSubFunctionData());
                break;
            }
        }
        return response;
    }

    protected boolean validateResponseImpl(ModbusResponse response) {
        DiagnosticsResponse r = (DiagnosticsResponse)response;
        if (this.getSubFunctionCode() != r.getSubFunctionCode()) {
            return false;
        }
        switch (this.subFunctionCode) {
            case RETURN_QUERY_DATA: 
            case RESTART_COMMUNICATIONS_OPTION: 
            case CHANGE_ASCII_INPUT_DELIMITER: 
            case CLEAR_COUNTERS_AND_DIAGNOSTIC_REGISTER: 
            case CLEAR_OVERRUN_COUNTER_AND_FLAG: {
                return this.getSubFunctionData() == r.getSubFunctionData();
            }
            case FORCE_LISTEN_ONLY_MODE: {
                break;
            }
            case RETURN_DIAGNOSTIC_REGISTER: {
                break;
            }
            case RETURN_BUS_MESSAGE_COUNT: {
                break;
            }
            case RETURN_BUS_COMMUNICATION_ERROR_COUNT: {
                break;
            }
            case RETURN_BUS_EXCEPTION_ERROR_COUNT: {
                break;
            }
            case RETURN_SLAVE_MESSAGE_COUNT: {
                break;
            }
            case RETURN_SLAVE_NO_RESPONSE_COUNT: {
                break;
            }
            case RETURN_SLAVE_NAK_COUNT: {
                break;
            }
            case RETURN_SLAVE_BUSY_COUNT: {
                break;
            }
            case RETURN_BUS_CHARACTER_OVERRUN_COUNT: {
                break;
            }
        }
        return true;
    }

    public void readPDU(ModbusInputStream fifo) throws ModbusNumberException, IOException {
        this.setSubFunctionCode(DiagnosticsSubFunctionCode.get(fifo.readShortBE()));
        this.setSubFunctionData(fifo.readShortBE());
    }

    public int getSubFunctionData() {
        return this.subFunctionData;
    }

    public void setSubFunctionData(int subFunctionData) {
        this.subFunctionData = subFunctionData;
    }

    public DiagnosticsSubFunctionCode getSubFunctionCode() {
        return this.subFunctionCode;
    }

    public void setSubFunctionCode(DiagnosticsSubFunctionCode subFunctionCode) {
        this.subFunctionCode = subFunctionCode;
    }

    public int getFunction() {
        return ModbusFunctionCode.DIAGNOSTICS.toInt();
    }
}

