/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.msg.base.mei;

import com.invertor.modbus.Modbus;
import com.invertor.modbus.data.DataHolder;
import com.invertor.modbus.data.mei.ReadDeviceIdentificationInterface;
import com.invertor.modbus.exception.IllegalDataAddressException;
import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.msg.base.mei.ConformityLevel;
import com.invertor.modbus.msg.base.mei.ModbusEncapsulatedInterface;
import com.invertor.modbus.msg.base.mei.ReadDeviceIdentificationCode;
import com.invertor.modbus.net.stream.base.ModbusInputStream;
import com.invertor.modbus.net.stream.base.ModbusOutputStream;
import com.invertor.modbus.utils.MEITypeCode;
import java.io.IOException;
import java.util.Arrays;

public class MEIReadDeviceIdentification
implements ModbusEncapsulatedInterface {
    public static final int SIZE_OF_HEADER = 8;
    private int objectId = 0;
    private ReadDeviceIdentificationCode readDeviceIdCode = ReadDeviceIdentificationCode.BASIC_STREAM_ACCESS;
    private ConformityLevel conformityLevel = ConformityLevel.BASIC_STREAM_ONLY;
    private boolean moreFollows = false;
    private int nextObjectId = 0;
    private int numberOfObjects = 0;
    private ReadDeviceIdentificationInterface.DataObject[] objects = new ReadDeviceIdentificationInterface.DataObject[0];
    private int responseSize = 0;
    private int firstObjectIndex = 0;

    public MEITypeCode getTypeCode() {
        return MEITypeCode.READ_DEVICE_IDENTIFICATION;
    }

    public void writeRequest(ModbusOutputStream fifo) throws IOException {
        fifo.write(this.getReadDeviceIdCode().toInt());
        fifo.write(this.getObjectId());
    }

    public void readRequest(ModbusInputStream fifo) throws IOException {
        this.setReadDeviceId(ReadDeviceIdentificationCode.get(fifo.read()));
        this.setObjectId(fifo.read());
    }

    public int getRequestSize() {
        return 2;
    }

    public void writeResponse(ModbusOutputStream fifo) throws IOException {
        fifo.write(this.getReadDeviceIdCode().toInt());
        fifo.write(this.getConformityLevel().toInt());
        fifo.write(this.isMoreFollows() ? 255 : 0);
        fifo.write(this.getNextObjectId());
        fifo.write(this.getNumberOfObjects());
        for (int i = this.getFirstObjectIndex(); i < this.getFirstObjectIndex() + this.getNumberOfObjects(); ++i) {
            ReadDeviceIdentificationInterface.DataObject o = this.objects[i];
            fifo.write(o.getId());
            fifo.write(o.getValue().length);
            fifo.write(o.getValue());
        }
    }

    public void readResponse(ModbusInputStream fifo) throws IOException, ModbusNumberException {
        this.setReadDeviceId(ReadDeviceIdentificationCode.get(fifo.read()));
        this.setConformityLevel(ConformityLevel.get(fifo.read()));
        this.setMoreFollows(fifo.read() == 255);
        this.setNextObjectId(fifo.read());
        this.setNumberOfObjects(fifo.read());
        if (this.getNumberOfObjects() > 127) {
            throw new ModbusNumberException("Illegal number of data objects", this.getNumberOfObjects());
        }
        this.setObjects(new ReadDeviceIdentificationInterface.DataObject[this.getNumberOfObjects()]);
        int size = 8;
        for (int i = 0; i < this.getNumberOfObjects(); ++i) {
            int id = fifo.read();
            int length = fifo.read();
            if ((size += 2 + length) > 254) {
                throw new ModbusNumberException("Exceeded max pdu length", size);
            }
            byte[] value = new byte[length];
            int read = fifo.read(value);
            if (read != length) {
                Modbus.log().warning(length + " bytes expected, but " + read + " received.");
            }
            this.objects[i] = new ReadDeviceIdentificationInterface.DataObject(id, value);
        }
        this.setResponseSize(size);
    }

    public int getResponseSize() {
        return this.responseSize;
    }

    public void setResponseSize(int responseSize) {
        this.responseSize = responseSize;
    }

    public void process(DataHolder dataHolder) throws IllegalDataAddressException {
        int i;
        ReadDeviceIdentificationInterface deviceId = dataHolder.getReadDeviceIdentificationInterface();
        if (deviceId.getExtended().length != 0) {
            this.setConformityLevel(ConformityLevel.EXTENDED_STREAM_AND_INDIVIDUAL);
        } else if (deviceId.getRegular().length != 0) {
            this.setConformityLevel(ConformityLevel.REGULAR_STREAM_AND_INDIVIDUAL);
        } else {
            this.setConformityLevel(ConformityLevel.BASIC_STREAM_AND_INDIVIDUAL);
        }
        switch (this.getReadDeviceIdCode()) {
            case BASIC_STREAM_ACCESS: {
                this.setObjects(deviceId.getBasic());
                break;
            }
            case REGULAR_STREAM_ACCESS: {
                this.setObjects(deviceId.getRegular());
                break;
            }
            case EXTENDED_STREAM_ACCESS: {
                this.setObjects(deviceId.getExtended());
                break;
            }
            default: {
                this.setObjects(new ReadDeviceIdentificationInterface.DataObject[]{deviceId.getValue(this.getObjectId())});
            }
        }
        int size = 8;
        int number_of_objects = 0;
        if (this.getObjectId() != 0) {
            for (i = 0; i < this.objects.length && this.getFirstObjectIndex() == 0; ++i) {
                if (this.objects[i].getId() != this.getObjectId()) continue;
                this.setFirstObjectIndex(i);
            }
        }
        for (i = this.getFirstObjectIndex(); i < this.objects.length && (size += this.objects[i].getValue().length + 2) < 254; ++i) {
            ++number_of_objects;
        }
        this.setResponseSize(size);
        if (this.objects.length - this.getFirstObjectIndex() > number_of_objects) {
            this.setNextObjectId(number_of_objects + 1);
        } else {
            this.setMoreFollows(false);
        }
        this.setNumberOfObjects(number_of_objects);
    }

    public int getNumberOfObjects() {
        return this.numberOfObjects;
    }

    public void setNumberOfObjects(int numberOfObjects) {
        this.numberOfObjects = numberOfObjects;
    }

    public int getObjectId() {
        return this.objectId;
    }

    public void setObjectId(int objectId) {
        this.objectId = objectId;
    }

    public ReadDeviceIdentificationCode getReadDeviceIdCode() {
        return this.readDeviceIdCode;
    }

    public void setReadDeviceId(ReadDeviceIdentificationCode readDeviceIdCode) {
        this.readDeviceIdCode = readDeviceIdCode;
    }

    public ConformityLevel getConformityLevel() {
        return this.conformityLevel;
    }

    public void setConformityLevel(ConformityLevel conformityLevel) {
        this.conformityLevel = conformityLevel;
    }

    public boolean isMoreFollows() {
        return this.moreFollows;
    }

    public void setMoreFollows(boolean moreFollows) {
        this.moreFollows = moreFollows;
    }

    public int getNextObjectId() {
        return this.nextObjectId;
    }

    public void setNextObjectId(int nextObjectId) {
        this.nextObjectId = nextObjectId;
    }

    public ReadDeviceIdentificationInterface.DataObject[] getObjects() {
        return Arrays.copyOf(this.objects, this.objects.length);
    }

    public void setObjects(ReadDeviceIdentificationInterface.DataObject[] objects) {
        this.objects = Arrays.copyOf(objects, objects.length);
    }

    public int getFirstObjectIndex() {
        return this.firstObjectIndex;
    }

    public void setFirstObjectIndex(int firstObjectIndex) {
        this.firstObjectIndex = firstObjectIndex;
    }
}

