/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.msg.base;

import com.invertor.modbus.data.DataHolder;
import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.msg.base.ModbusMessage;
import com.invertor.modbus.msg.base.ModbusResponse;
import com.invertor.modbus.net.stream.base.ModbusOutputStream;
import java.io.IOException;

public abstract class ModbusRequest
extends ModbusMessage {
    public ModbusRequest(int serverAddress) throws ModbusNumberException {
        super(serverAddress);
    }

    public abstract void writeRequest(ModbusOutputStream var1) throws IOException;

    public final void writePDU(ModbusOutputStream fifo) throws IOException {
        fifo.write(this.getFunction());
        this.writeRequest(fifo);
    }

    protected final int pduSize() {
        return 1 + this.requestSize();
    }

    public abstract int requestSize();

    public abstract ModbusResponse process(DataHolder var1) throws ModbusNumberException;

    protected abstract boolean validateResponseImpl(ModbusResponse var1);

    public void validateResponse(ModbusResponse msg) throws ModbusNumberException {
        if (this.getProtocolId() != msg.getProtocolId()) {
            throw new ModbusNumberException("Collision: does not matches the transaction id");
        }
        if (this.getTransactionId() != msg.getTransactionId()) {
            throw new ModbusNumberException("Collision: does not matches the transaction id");
        }
        if (this.getServerAddress() != msg.getServerAddress()) {
            throw new ModbusNumberException("Does not matches the slave address", msg.getServerAddress());
        }
        if (this.getFunction() != msg.getFunction()) {
            throw new ModbusNumberException("Does not matches the function code", msg.getFunction());
        }
        if (!msg.isException() && !this.validateResponseImpl(msg)) {
            throw new ModbusNumberException("Collision: response does not matches the request");
        }
    }
}

