/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.msg.base;

import com.invertor.modbus.Modbus;
import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.msg.base.ModbusResponse;
import com.invertor.modbus.net.stream.base.ModbusInputStream;
import com.invertor.modbus.net.stream.base.ModbusOutputStream;
import java.io.IOException;

public abstract class AbstractWriteResponse
extends ModbusResponse {
    private int startAddress = 0;

    protected AbstractWriteResponse(int serverAddress) throws ModbusNumberException {
        super(serverAddress);
    }

    protected AbstractWriteResponse(int serverAddress, int startAddress) throws ModbusNumberException {
        super(serverAddress);
        if (!Modbus.checkStartAddress(startAddress)) {
            throw new ModbusNumberException("Error in start address", startAddress);
        }
        this.setStartAddress(startAddress);
    }

    protected final void readResponse(ModbusInputStream fifo) throws IOException {
        this.setStartAddress(fifo.readShortBE());
        this.readValue(fifo);
    }

    public final void writeResponse(ModbusOutputStream fifo) throws IOException {
        fifo.writeShortBE(this.getStartAddress());
        this.writeValue(fifo);
    }

    protected abstract void readValue(ModbusInputStream var1) throws IOException;

    protected abstract void writeValue(ModbusOutputStream var1) throws IOException;

    public final int getStartAddress() {
        return this.startAddress;
    }

    private void setStartAddress(int startAddress) {
        this.startAddress = startAddress;
    }

    protected final int responseSize() {
        return 4;
    }
}

