/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.msg.base;

import com.invertor.modbus.Modbus;
import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.msg.base.AbstractMultipleRequest;
import com.invertor.modbus.net.stream.base.ModbusInputStream;
import com.invertor.modbus.net.stream.base.ModbusOutputStream;
import java.io.IOException;
import java.util.Arrays;

public abstract class AbstractWriteMultipleRequest
extends AbstractMultipleRequest {
    private byte[] values;
    private int byteCount;

    protected AbstractWriteMultipleRequest(int serverAddress) throws ModbusNumberException {
        super(serverAddress);
    }

    protected AbstractWriteMultipleRequest(int serverAddress, int startAddress, byte[] values, int quantity) throws ModbusNumberException {
        super(serverAddress, startAddress, quantity);
        this.setByteCount(values.length);
        this.setValues(values);
    }

    public void writeData(ModbusOutputStream fifo) throws IOException {
        super.writeData(fifo);
        fifo.write(this.getByteCount());
        fifo.write(this.getValues());
    }

    protected void readData(ModbusInputStream fifo) throws IOException, ModbusNumberException {
        super.readData(fifo);
        this.setByteCount(fifo.read());
        this.values = new byte[this.byteCount];
        int size = fifo.read(this.values, 0, this.getByteCount());
        if (size < this.getByteCount()) {
            Modbus.log().warning(this.getByteCount() + " bytes expected, but " + size + " received.");
        }
    }

    protected int getByteCount() {
        return this.byteCount;
    }

    private void setByteCount(int byteCount) {
        this.byteCount = byteCount;
    }

    public byte[] getValues() {
        return Arrays.copyOf(this.values, this.values.length);
    }

    public void setValues(byte[] values) {
        this.values = Arrays.copyOf(values, values.length);
    }

    protected int dataSize() {
        return super.dataSize() + 1 + this.getByteCount();
    }
}

