/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.msg.base;

import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.msg.base.ModbusResponse;
import com.invertor.modbus.net.stream.base.ModbusInputStream;
import com.invertor.modbus.net.stream.base.ModbusOutputStream;
import java.io.IOException;

public abstract class AbstractReadResponse
extends ModbusResponse {
    private int byteCount = 0;

    protected AbstractReadResponse(int serverAddress) throws ModbusNumberException {
        super(serverAddress);
    }

    protected AbstractReadResponse(int serverAddress, int byteCount) throws ModbusNumberException {
        super(serverAddress);
        this.byteCount = byteCount;
    }

    public int getByteCount() {
        return this.byteCount;
    }

    protected void setByteCount(int byteCount) throws ModbusNumberException {
        if (byteCount > 252) {
            throw new ModbusNumberException("Byte count greater than max allowable");
        }
        this.byteCount = byteCount;
    }

    public final void readResponse(ModbusInputStream fifo) throws IOException, ModbusNumberException {
        this.setByteCount(fifo.read());
        this.readData(fifo);
    }

    public final void writeResponse(ModbusOutputStream fifo) throws IOException {
        fifo.write(this.getByteCount());
        this.writeData(fifo);
    }

    protected abstract void readData(ModbusInputStream var1) throws IOException, ModbusNumberException;

    protected abstract void writeData(ModbusOutputStream var1) throws IOException;

    protected final int responseSize() {
        return 1 + this.getByteCount();
    }
}

