/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.msg.base;

import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.msg.base.AbstractDataRequest;
import com.invertor.modbus.net.stream.base.ModbusInputStream;
import com.invertor.modbus.net.stream.base.ModbusOutputStream;
import java.io.IOException;

public abstract class AbstractMultipleRequest
extends AbstractDataRequest {
    private int quantity;

    protected AbstractMultipleRequest(int serverAddress) throws ModbusNumberException {
        super(serverAddress);
    }

    protected AbstractMultipleRequest(int serverAddress, int startAddress, int quantity) throws ModbusNumberException {
        super(serverAddress, startAddress);
        if (!this.checkAddressRange(startAddress, quantity)) {
            throw new ModbusNumberException("Error in start address", startAddress);
        }
        this.setQuantity(quantity);
    }

    protected void readData(ModbusInputStream fifo) throws IOException, ModbusNumberException {
        this.setQuantity(fifo.readShortBE());
    }

    protected void writeData(ModbusOutputStream fifo) throws IOException {
        fifo.writeShortBE(this.quantity);
    }

    protected int dataSize() {
        return 2;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    protected abstract boolean checkAddressRange(int var1, int var2);
}

