/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.msg;

import com.invertor.modbus.exception.ModbusIOException;
import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.msg.ModbusMessageFactory;
import com.invertor.modbus.msg.base.ModbusMessage;
import com.invertor.modbus.msg.base.ModbusResponse;
import com.invertor.modbus.msg.response.DiagnosticsResponse;
import com.invertor.modbus.msg.response.EncapsulatedInterfaceTransportResponse;
import com.invertor.modbus.msg.response.GetCommEventCounterResponse;
import com.invertor.modbus.msg.response.GetCommEventLogResponse;
import com.invertor.modbus.msg.response.MaskWriteRegisterResponse;
import com.invertor.modbus.msg.response.ReadCoilsResponse;
import com.invertor.modbus.msg.response.ReadDiscreteInputsResponse;
import com.invertor.modbus.msg.response.ReadExceptionStatusResponse;
import com.invertor.modbus.msg.response.ReadFifoQueueResponse;
import com.invertor.modbus.msg.response.ReadFileRecordResponse;
import com.invertor.modbus.msg.response.ReadHoldingRegistersResponse;
import com.invertor.modbus.msg.response.ReadInputRegistersResponse;
import com.invertor.modbus.msg.response.ReadWriteMultipleRegistersResponse;
import com.invertor.modbus.msg.response.ReportSlaveIdResponse;
import com.invertor.modbus.msg.response.WriteFileRecordResponse;
import com.invertor.modbus.msg.response.WriteMultipleCoilsResponse;
import com.invertor.modbus.msg.response.WriteMultipleRegistersResponse;
import com.invertor.modbus.msg.response.WriteSingleCoilResponse;
import com.invertor.modbus.msg.response.WriteSingleRegisterResponse;
import com.invertor.modbus.net.stream.base.ModbusInputStream;
import com.invertor.modbus.utils.ModbusFunctionCode;
import java.io.IOException;

public final class ModbusResponseFactory
implements ModbusMessageFactory {
    private ModbusResponseFactory() {
    }

    public static ModbusResponseFactory getInstance() {
        return SingletonHolder.instance;
    }

    public ModbusMessage createMessage(ModbusInputStream fifo) throws ModbusNumberException, ModbusIOException {
        ModbusResponse msg;
        int functionCode;
        int serverAddress;
        try {
            serverAddress = fifo.read();
            functionCode = fifo.read();
        }
        catch (IOException e) {
            throw new ModbusIOException(e);
        }
        switch (ModbusFunctionCode.get(functionCode)) {
            case READ_COILS: {
                msg = new ReadCoilsResponse(serverAddress);
                break;
            }
            case READ_DISCRETE_INPUTS: {
                msg = new ReadDiscreteInputsResponse(serverAddress);
                break;
            }
            case READ_HOLDING_REGISTERS: {
                msg = new ReadHoldingRegistersResponse(serverAddress);
                break;
            }
            case READ_INPUT_REGISTERS: {
                msg = new ReadInputRegistersResponse(serverAddress);
                break;
            }
            case WRITE_SINGLE_COIL: {
                msg = new WriteSingleCoilResponse(serverAddress);
                break;
            }
            case WRITE_SINGLE_REGISTER: {
                msg = new WriteSingleRegisterResponse(serverAddress);
                break;
            }
            case WRITE_MULTIPLE_COILS: {
                msg = new WriteMultipleCoilsResponse(serverAddress);
                break;
            }
            case WRITE_MULTIPLE_REGISTERS: {
                msg = new WriteMultipleRegistersResponse(serverAddress);
                break;
            }
            case MASK_WRITE_REGISTER: {
                msg = new MaskWriteRegisterResponse(serverAddress);
                break;
            }
            case READ_WRITE_MULTIPLE_REGISTERS: {
                msg = new ReadWriteMultipleRegistersResponse(serverAddress);
                break;
            }
            case READ_FIFO_QUEUE: {
                msg = new ReadFifoQueueResponse(serverAddress);
                break;
            }
            case READ_FILE_RECORD: {
                msg = new ReadFileRecordResponse(serverAddress);
                break;
            }
            case WRITE_FILE_RECORD: {
                msg = new WriteFileRecordResponse(serverAddress);
                break;
            }
            case READ_EXCEPTION_STATUS: {
                msg = new ReadExceptionStatusResponse(serverAddress);
                break;
            }
            case REPORT_SLAVE_ID: {
                msg = new ReportSlaveIdResponse(serverAddress);
                break;
            }
            case GET_COMM_EVENT_COUNTER: {
                msg = new GetCommEventCounterResponse(serverAddress);
                break;
            }
            case GET_COMM_EVENT_LOG: {
                msg = new GetCommEventLogResponse(serverAddress);
                break;
            }
            case DIAGNOSTICS: {
                msg = new DiagnosticsResponse(serverAddress);
                break;
            }
            case ENCAPSULATED_INTERFACE_TRANSPORT: {
                msg = new EncapsulatedInterfaceTransportResponse(serverAddress);
                break;
            }
            default: {
                throw new ModbusNumberException("Unknown function code", functionCode);
            }
        }
        if (ModbusFunctionCode.isException(functionCode)) {
            msg.setException();
        }
        msg.read(fifo);
        return msg;
    }

    private static class SingletonHolder {
        private static final ModbusResponseFactory instance = new ModbusResponseFactory();

        private SingletonHolder() {
        }
    }
}

