/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.msg;

import com.invertor.modbus.exception.ModbusIOException;
import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.msg.ModbusMessageFactory;
import com.invertor.modbus.msg.base.ModbusFileRecord;
import com.invertor.modbus.msg.base.ModbusMessage;
import com.invertor.modbus.msg.base.ModbusRequest;
import com.invertor.modbus.msg.base.mei.ReadDeviceIdentificationCode;
import com.invertor.modbus.msg.request.DiagnosticsRequest;
import com.invertor.modbus.msg.request.EncapsulatedInterfaceTransportRequest;
import com.invertor.modbus.msg.request.GetCommEventCounterRequest;
import com.invertor.modbus.msg.request.GetCommEventLogRequest;
import com.invertor.modbus.msg.request.IllegalFunctionRequest;
import com.invertor.modbus.msg.request.MaskWriteRegisterRequest;
import com.invertor.modbus.msg.request.ReadCoilsRequest;
import com.invertor.modbus.msg.request.ReadDeviceIdentificationRequest;
import com.invertor.modbus.msg.request.ReadDiscreteInputsRequest;
import com.invertor.modbus.msg.request.ReadExceptionStatusRequest;
import com.invertor.modbus.msg.request.ReadFifoQueueRequest;
import com.invertor.modbus.msg.request.ReadFileRecordRequest;
import com.invertor.modbus.msg.request.ReadHoldingRegistersRequest;
import com.invertor.modbus.msg.request.ReadInputRegistersRequest;
import com.invertor.modbus.msg.request.ReadWriteMultipleRegistersRequest;
import com.invertor.modbus.msg.request.ReportSlaveIdRequest;
import com.invertor.modbus.msg.request.WriteFileRecordRequest;
import com.invertor.modbus.msg.request.WriteMultipleCoilsRequest;
import com.invertor.modbus.msg.request.WriteMultipleRegistersRequest;
import com.invertor.modbus.msg.request.WriteSingleCoilRequest;
import com.invertor.modbus.msg.request.WriteSingleRegisterRequest;
import com.invertor.modbus.net.stream.base.ModbusInputStream;
import com.invertor.modbus.utils.DiagnosticsSubFunctionCode;
import com.invertor.modbus.utils.ModbusFunctionCode;
import java.io.IOException;

public final class ModbusRequestFactory
implements ModbusMessageFactory {
    private ModbusRequestFactory() {
    }

    public static ModbusRequestFactory getInstance() {
        return SingletonHolder.instance;
    }

    public ModbusRequest createReadCoils(int serverAddress, int startAddress, int quantity) throws ModbusNumberException {
        return new ReadCoilsRequest(serverAddress, startAddress, quantity);
    }

    public ModbusRequest createReadDiscreteInputs(int serverAddress, int startAddress, int quantity) throws ModbusNumberException {
        return new ReadDiscreteInputsRequest(serverAddress, startAddress, quantity);
    }

    public ModbusRequest createReadInputRegisters(int serverAddress, int startAddress, int quantity) throws ModbusNumberException {
        return new ReadInputRegistersRequest(serverAddress, startAddress, quantity);
    }

    public ModbusRequest createReadHoldingRegisters(int serverAddress, int startAddress, int quantity) throws ModbusNumberException {
        return new ReadHoldingRegistersRequest(serverAddress, startAddress, quantity);
    }

    public ModbusRequest createReadWriteMultipleRegisters(int serverAddress, int readAddress, int readQuantity, int writeAddress, int[] registers) throws ModbusNumberException {
        return new ReadWriteMultipleRegistersRequest(serverAddress, readAddress, readQuantity, writeAddress, registers);
    }

    public ModbusRequest createWriteSingleCoil(int serverAddress, int startAddress, boolean coil) throws ModbusNumberException {
        return new WriteSingleCoilRequest(serverAddress, startAddress, coil);
    }

    public ModbusRequest createWriteMultipleCoils(int serverAddress, int startAddress, boolean[] coils) throws ModbusNumberException {
        return new WriteMultipleCoilsRequest(serverAddress, startAddress, coils);
    }

    public ModbusRequest createWriteMultipleRegisters(int serverAddress, int startAddress, int[] registers) throws ModbusNumberException {
        return new WriteMultipleRegistersRequest(serverAddress, startAddress, registers);
    }

    public ModbusRequest createWriteMultipleRegisters(int serverAddress, int startAddress, byte[] bytes) throws ModbusNumberException {
        return new WriteMultipleRegistersRequest(serverAddress, startAddress, bytes);
    }

    public ModbusRequest createWriteSingleRegister(int serverAddress, int startAddress, int register) throws ModbusNumberException {
        return new WriteSingleRegisterRequest(serverAddress, startAddress, register);
    }

    public ModbusRequest createMaskWriteRegister(int serverAddress, int startAddress, int and, int or) throws ModbusNumberException {
        return new MaskWriteRegisterRequest(serverAddress, startAddress, and, or);
    }

    public ModbusRequest createReadExceptionStatus(int serverAddress) throws ModbusNumberException {
        return new ReadExceptionStatusRequest(serverAddress);
    }

    public ModbusRequest createReportSlaveId(int serverAddress) throws ModbusNumberException {
        return new ReportSlaveIdRequest(serverAddress);
    }

    public ModbusRequest createGetCommEventCounter(int serverAddress) throws ModbusNumberException {
        return new GetCommEventCounterRequest(serverAddress);
    }

    public ModbusRequest createGetCommEventLog(int serverAddress) throws ModbusNumberException {
        return new GetCommEventLogRequest(serverAddress);
    }

    public ModbusRequest createReadFifoQueue(int serverAddress, int fifoPointerAddress) throws ModbusNumberException {
        return new ReadFifoQueueRequest(serverAddress, fifoPointerAddress);
    }

    public ModbusRequest createReadFileRecord(int serverAddress, ModbusFileRecord[] records) throws ModbusNumberException {
        return new ReadFileRecordRequest(serverAddress, records);
    }

    public ModbusRequest createWriteFileRecord(int serverAddress, ModbusFileRecord record) throws ModbusNumberException {
        return new WriteFileRecordRequest(serverAddress, record);
    }

    public ModbusRequest createDiagnostics(DiagnosticsSubFunctionCode subFunctionCode, int serverAddress, int data) throws ModbusNumberException {
        DiagnosticsRequest request = new DiagnosticsRequest(serverAddress);
        request.setSubFunctionCode(subFunctionCode);
        request.setSubFunctionData(data);
        return request;
    }

    public ModbusRequest createReturnQueryData(int serverAddress, int queryData) throws ModbusNumberException {
        return this.createDiagnostics(DiagnosticsSubFunctionCode.RETURN_QUERY_DATA, serverAddress, queryData);
    }

    public ModbusRequest createRestartCommunicationsOption(int serverAddress, boolean clearLog) throws ModbusNumberException {
        return this.createDiagnostics(DiagnosticsSubFunctionCode.RESTART_COMMUNICATIONS_OPTION, serverAddress, clearLog ? 65280 : 0);
    }

    public ModbusRequest createReturnDiagnosticRegister(int serverAddress) throws ModbusNumberException {
        return this.createDiagnostics(DiagnosticsSubFunctionCode.RETURN_DIAGNOSTIC_REGISTER, serverAddress, 0);
    }

    public ModbusRequest createChangeAsciiInputDelimiter(int serverAddress, int delimiter) throws ModbusNumberException {
        return this.createDiagnostics(DiagnosticsSubFunctionCode.CHANGE_ASCII_INPUT_DELIMITER, serverAddress, delimiter);
    }

    public ModbusRequest createForceListenOnlyMode(int serverAddress) throws ModbusNumberException {
        return this.createDiagnostics(DiagnosticsSubFunctionCode.FORCE_LISTEN_ONLY_MODE, serverAddress, 0);
    }

    public ModbusRequest createClearCountersAndDiagnosticRegister(int serverAddress) throws ModbusNumberException {
        return this.createDiagnostics(DiagnosticsSubFunctionCode.CLEAR_COUNTERS_AND_DIAGNOSTIC_REGISTER, serverAddress, 0);
    }

    public ModbusRequest createReturnBusMessageCount(int serverAddress) throws ModbusNumberException {
        return this.createDiagnostics(DiagnosticsSubFunctionCode.RETURN_BUS_MESSAGE_COUNT, serverAddress, 0);
    }

    public ModbusRequest createReturnBusCommunicationErrorCount(int serverAddress) throws ModbusNumberException {
        return this.createDiagnostics(DiagnosticsSubFunctionCode.RETURN_BUS_COMMUNICATION_ERROR_COUNT, serverAddress, 0);
    }

    public ModbusRequest createReturnBusExceptionErrorCount(int serverAddress) throws ModbusNumberException {
        return this.createDiagnostics(DiagnosticsSubFunctionCode.RETURN_BUS_EXCEPTION_ERROR_COUNT, serverAddress, 0);
    }

    public ModbusRequest createReturnSlaveMessageCount(int serverAddress) throws ModbusNumberException {
        return this.createDiagnostics(DiagnosticsSubFunctionCode.RETURN_SLAVE_MESSAGE_COUNT, serverAddress, 0);
    }

    public ModbusRequest createReturnSlaveNoResponseCount(int serverAddress) throws ModbusNumberException {
        return this.createDiagnostics(DiagnosticsSubFunctionCode.RETURN_SLAVE_NO_RESPONSE_COUNT, serverAddress, 0);
    }

    public ModbusRequest createReturnSlaveNAKCount(int serverAddress) throws ModbusNumberException {
        return this.createDiagnostics(DiagnosticsSubFunctionCode.RETURN_SLAVE_NAK_COUNT, serverAddress, 0);
    }

    public ModbusRequest createReturnSlaveBusyCount(int serverAddress) throws ModbusNumberException {
        return this.createDiagnostics(DiagnosticsSubFunctionCode.RETURN_SLAVE_BUSY_COUNT, serverAddress, 0);
    }

    public ModbusRequest createReturnBusCharacterOverrunCount(int serverAddress) throws ModbusNumberException {
        return this.createDiagnostics(DiagnosticsSubFunctionCode.RETURN_BUS_CHARACTER_OVERRUN_COUNT, serverAddress, 0);
    }

    public ModbusRequest createClearOverrunCounterAndFlag(int serverAddress) throws ModbusNumberException {
        return this.createDiagnostics(DiagnosticsSubFunctionCode.CLEAR_OVERRUN_COUNTER_AND_FLAG, serverAddress, 0);
    }

    public ModbusRequest createReadDeviceIdentification(int serverAddress, int objectId, ReadDeviceIdentificationCode readDeviceId) throws ModbusNumberException {
        return new ReadDeviceIdentificationRequest(serverAddress, objectId, readDeviceId);
    }

    public ModbusMessage createMessage(ModbusInputStream fifo) throws ModbusNumberException, ModbusIOException {
        ModbusRequest msg;
        int functionCode;
        int serverAddress;
        try {
            serverAddress = fifo.read();
            functionCode = fifo.read();
        }
        catch (IOException e) {
            throw new ModbusIOException(e);
        }
        switch (ModbusFunctionCode.get(functionCode)) {
            case READ_COILS: {
                msg = new ReadCoilsRequest(serverAddress);
                break;
            }
            case READ_DISCRETE_INPUTS: {
                msg = new ReadDiscreteInputsRequest(serverAddress);
                break;
            }
            case READ_HOLDING_REGISTERS: {
                msg = new ReadHoldingRegistersRequest(serverAddress);
                break;
            }
            case READ_INPUT_REGISTERS: {
                msg = new ReadInputRegistersRequest(serverAddress);
                break;
            }
            case WRITE_SINGLE_COIL: {
                msg = new WriteSingleCoilRequest(serverAddress);
                break;
            }
            case WRITE_SINGLE_REGISTER: {
                msg = new WriteSingleRegisterRequest(serverAddress);
                break;
            }
            case WRITE_MULTIPLE_COILS: {
                msg = new WriteMultipleCoilsRequest(serverAddress);
                break;
            }
            case WRITE_MULTIPLE_REGISTERS: {
                msg = new WriteMultipleRegistersRequest(serverAddress);
                break;
            }
            case MASK_WRITE_REGISTER: {
                msg = new MaskWriteRegisterRequest(serverAddress);
                break;
            }
            case READ_WRITE_MULTIPLE_REGISTERS: {
                msg = new ReadWriteMultipleRegistersRequest(serverAddress);
                break;
            }
            case READ_FIFO_QUEUE: {
                msg = new ReadFifoQueueRequest(serverAddress);
                break;
            }
            case READ_FILE_RECORD: {
                msg = new ReadFileRecordRequest(serverAddress);
                break;
            }
            case WRITE_FILE_RECORD: {
                msg = new WriteFileRecordRequest(serverAddress);
                break;
            }
            case READ_EXCEPTION_STATUS: {
                msg = new ReadExceptionStatusRequest(serverAddress);
                break;
            }
            case REPORT_SLAVE_ID: {
                msg = new ReportSlaveIdRequest(serverAddress);
                break;
            }
            case GET_COMM_EVENT_COUNTER: {
                msg = new GetCommEventCounterRequest(serverAddress);
                break;
            }
            case GET_COMM_EVENT_LOG: {
                msg = new GetCommEventLogRequest(serverAddress);
                break;
            }
            case DIAGNOSTICS: {
                msg = new DiagnosticsRequest(serverAddress);
                break;
            }
            case ENCAPSULATED_INTERFACE_TRANSPORT: {
                msg = new EncapsulatedInterfaceTransportRequest(serverAddress);
                break;
            }
            default: {
                msg = new IllegalFunctionRequest(serverAddress, functionCode);
            }
        }
        msg.read(fifo);
        return msg;
    }

    private static class SingletonHolder {
        private static final ModbusRequestFactory instance = new ModbusRequestFactory();

        private SingletonHolder() {
        }
    }
}

