/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.data.mei;

import com.invertor.modbus.exception.IllegalDataAddressException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.TreeMap;

public class ReadDeviceIdentificationInterface {
    public static final int BASIC_OBJECT_COUNT = 3;
    public static final int REGULAR_OBJECT_COUNT = 125;
    public static final int EXTENDED_OBJECT_COUNT = 127;
    public static final int OBJECT_ID_VENDOR_NAME = 0;
    public static final int OBJECT_ID_PRODUCT_CODE = 1;
    public static final int OBJECT_ID_MAJOR_MINOR_REVISION = 2;
    public static final int OBJECT_ID_VENDOR_URL = 3;
    public static final int OBJECT_ID_PRODUCT_NAME = 4;
    public static final int OBJECT_ID_MODEL_NAME = 5;
    public static final int OBJECT_ID_USER_APPLICATION_NAME = 6;
    private final DataObjectsHolder dataObjectsBasic = new DataObjectsHolder(3);
    private final DataObjectsHolder dataObjectsRegular = new DataObjectsHolder(125);
    private final DataObjectsHolder dataObjectsExtended = new DataObjectsHolder(127);

    public ReadDeviceIdentificationInterface() {
        for (int i = 0; i < 3; ++i) {
            this.dataObjectsBasic.add(new DataObject(i, new byte[0]));
        }
    }

    DataObjectsHolder getDataObjectsHolder(int id) {
        if (id < 0) {
            throw new IllegalArgumentException();
        }
        if (id >= 125) {
            return this.dataObjectsExtended;
        }
        if (id >= 3) {
            return this.dataObjectsRegular;
        }
        return this.dataObjectsBasic;
    }

    public void setValue(int id, String value) {
        this.setValue(new DataObject(id, value.getBytes(Charset.forName("UTF-8"))));
    }

    public void setValue(DataObject dataObject) {
        this.getDataObjectsHolder(dataObject.getId()).add(dataObject);
    }

    public DataObject getValue(int id) {
        return this.getDataObjectsHolder(id).get(id);
    }

    public DataObject getVendorName() {
        return this.getValue(0);
    }

    public void setVendorName(String value) {
        this.setValue(0, value);
    }

    public DataObject getProductCode() {
        return this.getValue(1);
    }

    public void setProductCode(String value) {
        this.setValue(1, value);
    }

    public DataObject getMajorMinorRevision() {
        return this.getValue(2);
    }

    public void setMajorMinorRevision(String value) {
        this.setValue(2, value);
    }

    public DataObject getVendorUrl() throws IllegalDataAddressException {
        return this.getValue(3);
    }

    public void setVendorUrl(String value) {
        this.setValue(3, value);
    }

    public DataObject getProductName() throws IllegalDataAddressException {
        return this.getValue(4);
    }

    public void setProductName(String value) {
        this.setValue(4, value);
    }

    public DataObject getModelName() throws IllegalDataAddressException {
        return this.getValue(5);
    }

    public void setModelName(String value) {
        this.setValue(5, value);
    }

    public DataObject getUserApplicationName() throws IllegalDataAddressException {
        return this.getValue(6);
    }

    public void setUserApplicationName(String value) {
        this.setValue(6, value);
    }

    public DataObject[] getBasic() throws IllegalDataAddressException {
        return this.dataObjectsBasic.toArray();
    }

    public DataObject[] getRegular() throws IllegalDataAddressException {
        return this.dataObjectsRegular.toArray();
    }

    public DataObject[] getExtended() throws IllegalDataAddressException {
        return this.dataObjectsExtended.toArray();
    }

    private static class DataObjectsHolder {
        private final int capacity;
        TreeMap<Integer, DataObject> map;

        public DataObjectsHolder(int capacity) {
            this.capacity = capacity;
            this.map = new TreeMap();
        }

        public void add(DataObject dataObject) {
            if (this.map.containsKey(dataObject.getId())) {
                this.map.get(dataObject.getId()).setValue(dataObject.getValue());
            } else if (this.map.size() < this.capacity) {
                this.map.put(dataObject.getId(), dataObject);
            }
        }

        public DataObject get(int id) {
            return this.map.get(id);
        }

        public DataObject[] toArray() {
            return this.map.values().toArray(new DataObject[this.map.size()]);
        }
    }

    public static class DataObject {
        private final int id;
        private byte[] value;

        public DataObject(int id, byte[] value) {
            this.id = id;
            this.setValue(value);
        }

        public int getId() {
            return this.id;
        }

        public byte[] getValue() {
            return Arrays.copyOf(this.value, this.value.length);
        }

        public void setValue(byte[] value) {
            this.value = Arrays.copyOf(value, value.length);
        }
    }
}

