/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.data;

import com.invertor.modbus.data.ModbusFile;
import com.invertor.modbus.exception.IllegalDataAddressException;
import com.invertor.modbus.exception.IllegalDataValueException;
import com.invertor.modbus.msg.base.ModbusFileRecord;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;

public class SimpleModbusFile
extends ModbusFile {
    private final Map<Integer, ModbusFileRecord> records = new TreeMap<Integer, ModbusFileRecord>();

    public SimpleModbusFile(int number) {
        super(number);
    }

    public synchronized int[] read(int recordNumber, int recordLength) throws IllegalDataAddressException {
        if (!this.records.containsKey(recordNumber)) {
            throw new IllegalDataAddressException(recordNumber);
        }
        int[] buffer = this.records.get(recordNumber).getRegisters();
        if (buffer.length < recordLength) {
            throw new IllegalDataAddressException(recordLength);
        }
        return Arrays.copyOf(buffer, recordLength);
    }

    public synchronized void write(int recordNumber, int[] buffer) throws IllegalDataAddressException, IllegalDataValueException {
        if (this.records.containsKey(recordNumber)) {
            this.records.get(recordNumber).writeRegisters(buffer);
        } else {
            this.records.put(recordNumber, new ModbusFileRecord(this.getNumber(), recordNumber, buffer));
        }
        super.write(recordNumber, buffer);
    }
}

