/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.data;

import com.invertor.modbus.Modbus;
import com.invertor.modbus.data.HoldingRegisters;
import com.invertor.modbus.exception.IllegalDataAddressException;
import com.invertor.modbus.exception.IllegalDataValueException;
import java.util.Arrays;

public class SimpleHoldingRegisters
extends HoldingRegisters {
    private int[] registers = new int[0];

    public SimpleHoldingRegisters(int size) {
        this.registers = new int[Modbus.checkEndAddress(size) ? size : 65535];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSize(int size) {
        SimpleHoldingRegisters simpleHoldingRegisters = this;
        synchronized (simpleHoldingRegisters) {
            if (this.registers.length != size) {
                this.registers = Arrays.copyOf(this.registers, size);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(int offset, int value) throws IllegalDataAddressException, IllegalDataValueException {
        this.checkAddress(offset);
        this.checkValue(value);
        SimpleHoldingRegisters simpleHoldingRegisters = this;
        synchronized (simpleHoldingRegisters) {
            this.registers[offset] = value;
        }
        super.set(offset, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRange(int offset, int[] range) throws IllegalDataAddressException, IllegalDataValueException {
        this.checkRange(offset, range.length);
        if (!Modbus.checkWriteRegisterCount(range.length)) {
            throw new IllegalDataAddressException(offset);
        }
        SimpleHoldingRegisters simpleHoldingRegisters = this;
        synchronized (simpleHoldingRegisters) {
            System.arraycopy(range, 0, this.registers, offset, range.length);
        }
        super.setRange(offset, range);
    }

    public synchronized int quantity() {
        return this.registers.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get(int offset) throws IllegalDataAddressException {
        this.checkAddress(offset);
        SimpleHoldingRegisters simpleHoldingRegisters = this;
        synchronized (simpleHoldingRegisters) {
            return this.registers[offset];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getRange(int offset, int quantity) throws IllegalDataAddressException, IllegalDataValueException {
        this.checkRange(offset, quantity);
        if (!Modbus.checkReadRegisterCount(quantity)) {
            throw new IllegalDataAddressException(offset);
        }
        SimpleHoldingRegisters simpleHoldingRegisters = this;
        synchronized (simpleHoldingRegisters) {
            return Arrays.copyOfRange(this.registers, offset, offset + quantity);
        }
    }

    private void checkRange(int offset, int quantity) throws IllegalDataAddressException {
        if (offset + quantity > this.quantity()) {
            throw new IllegalDataAddressException(offset);
        }
    }

    private void checkAddress(int offset) throws IllegalDataAddressException {
        if (offset > this.quantity() - 1) {
            throw new IllegalDataAddressException(offset);
        }
    }

    private void checkValue(int value) throws IllegalDataValueException {
        if (!Modbus.checkRegisterValue(value)) {
            throw new IllegalDataValueException();
        }
    }
}

