/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.data;

import com.invertor.modbus.Modbus;
import com.invertor.modbus.data.Coils;
import com.invertor.modbus.exception.IllegalDataAddressException;
import com.invertor.modbus.exception.IllegalDataValueException;
import java.util.Arrays;

public class SimpleCoils
extends Coils {
    private boolean[] coils = new boolean[0];

    public SimpleCoils(int size) {
        this.coils = new boolean[Modbus.checkEndAddress(size) ? size : 65535];
    }

    void setSize(int size) {
        if (this.coils.length != size) {
            this.coils = Arrays.copyOf(this.coils, size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(int offset, boolean coil) throws IllegalDataAddressException {
        this.checkAddress(offset);
        SimpleCoils simpleCoils = this;
        synchronized (simpleCoils) {
            this.coils[offset] = coil;
        }
        super.set(offset, coil);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRange(int offset, boolean[] range) throws IllegalDataAddressException, IllegalDataValueException {
        this.checkRange(offset, range.length);
        if (!Modbus.checkWriteCoilCount(range.length)) {
            throw new IllegalDataValueException();
        }
        SimpleCoils simpleCoils = this;
        synchronized (simpleCoils) {
            System.arraycopy(range, 0, this.coils, offset, range.length);
        }
        super.setRange(offset, range);
    }

    public synchronized int quantity() {
        return this.coils.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean get(int offset) throws IllegalDataAddressException {
        this.checkAddress(offset);
        SimpleCoils simpleCoils = this;
        synchronized (simpleCoils) {
            return this.coils[offset];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean[] getRange(int offset, int quantity) throws IllegalDataAddressException, IllegalDataValueException {
        this.checkRange(offset, quantity);
        if (!Modbus.checkReadCoilCount(quantity)) {
            throw new IllegalDataValueException();
        }
        SimpleCoils simpleCoils = this;
        synchronized (simpleCoils) {
            return Arrays.copyOfRange(this.coils, offset, offset + quantity);
        }
    }

    private void checkRange(int offset, int quantity) throws IllegalDataAddressException {
        if (offset + quantity > this.quantity()) {
            throw new IllegalDataAddressException(offset);
        }
    }

    private void checkAddress(int offset) throws IllegalDataAddressException {
        if (!Modbus.checkStartAddress(offset)) {
            throw new IllegalDataAddressException(offset);
        }
    }
}

