/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.data;

import com.invertor.modbus.exception.IllegalDataValueException;

public abstract class FifoQueue {
    private final int capacity;

    public FifoQueue(int capacity) {
        this.capacity = capacity;
    }

    public abstract int size();

    protected abstract int[] peekImpl();

    protected abstract void addImpl(int var1);

    protected abstract void pollImpl();

    public final synchronized void poll() {
        if (this.size() != 0) {
            this.pollImpl();
        }
    }

    public final synchronized void add(int register) {
        if (this.size() < this.capacity) {
            this.addImpl(register);
        }
    }

    public final synchronized int[] get() throws IllegalDataValueException {
        if (this.size() > 31 || this.size() == 0) {
            throw new IllegalDataValueException();
        }
        return this.peekImpl();
    }
}

