/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.data;

import com.invertor.modbus.data.Coils;
import com.invertor.modbus.data.CommStatus;
import com.invertor.modbus.data.ExceptionStatus;
import com.invertor.modbus.data.FifoQueue;
import com.invertor.modbus.data.HoldingRegisters;
import com.invertor.modbus.data.ModbusFile;
import com.invertor.modbus.data.SlaveId;
import com.invertor.modbus.data.mei.ReadDeviceIdentificationInterface;
import com.invertor.modbus.exception.IllegalDataAddressException;
import com.invertor.modbus.exception.IllegalDataValueException;
import com.invertor.modbus.exception.IllegalFunctionException;
import com.invertor.modbus.msg.base.ModbusFileRecord;
import com.invertor.modbus.utils.ModbusFunctionCode;
import java.util.Map;
import java.util.TreeMap;

public class DataHolder {
    private final CommStatus commStatus = new CommStatus();
    private final Map<Integer, FifoQueue> fifoMap = new TreeMap<Integer, FifoQueue>();
    private final Map<Integer, ModbusFile> fileMap = new TreeMap<Integer, ModbusFile>();
    private Coils coils = null;
    private Coils discreteInputs = null;
    private HoldingRegisters holdingRegisters = null;
    private HoldingRegisters inputRegisters = null;
    private SlaveId slaveId = null;
    private ExceptionStatus exceptionStatus = null;
    private ReadDeviceIdentificationInterface readDeviceIdentificationInterface = null;

    private void checkPointer(Object o, int offset) throws IllegalDataAddressException {
        if (o == null) {
            throw new IllegalDataAddressException(offset);
        }
    }

    public int readHoldingRegister(int offset) throws IllegalDataAddressException {
        this.checkPointer(this.holdingRegisters, offset);
        return this.holdingRegisters.get(offset);
    }

    public int[] readHoldingRegisterRange(int offset, int quantity) throws IllegalDataAddressException, IllegalDataValueException {
        this.checkPointer(this.holdingRegisters, offset);
        return this.holdingRegisters.getRange(offset, quantity);
    }

    public void writeHoldingRegister(int offset, int value) throws IllegalDataAddressException, IllegalDataValueException {
        this.checkPointer(this.holdingRegisters, offset);
        this.holdingRegisters.set(offset, value);
    }

    public void writeHoldingRegisterRange(int offset, int[] range) throws IllegalDataAddressException, IllegalDataValueException {
        this.checkPointer(this.holdingRegisters, offset);
        this.holdingRegisters.setRange(offset, range);
    }

    public int[] readInputRegisterRange(int offset, int quantity) throws IllegalDataAddressException, IllegalDataValueException {
        this.checkPointer(this.inputRegisters, offset);
        return this.inputRegisters.getRange(offset, quantity);
    }

    public int[] readFifoQueue(int fifoPointerAddress) throws IllegalDataValueException, IllegalDataAddressException {
        FifoQueue fifoQueue = this.fifoMap.get(fifoPointerAddress);
        this.checkPointer(fifoQueue, fifoPointerAddress);
        return fifoQueue.get();
    }

    public boolean[] readCoilRange(int offset, int quantity) throws IllegalDataAddressException, IllegalDataValueException {
        this.checkPointer(this.holdingRegisters, offset);
        return this.coils.getRange(offset, quantity);
    }

    public void writeCoil(int offset, boolean value) throws IllegalDataAddressException {
        this.checkPointer(this.coils, offset);
        this.coils.set(offset, value);
    }

    public void writeCoilRange(int offset, boolean[] range) throws IllegalDataAddressException, IllegalDataValueException {
        this.checkPointer(this.coils, offset);
        this.coils.setRange(offset, range);
    }

    public byte[] readSlaveId() throws IllegalFunctionException {
        if (this.slaveId == null) {
            throw new IllegalFunctionException(ModbusFunctionCode.REPORT_SLAVE_ID.toInt());
        }
        return this.slaveId.get();
    }

    public int readExceptionStatus() throws IllegalFunctionException {
        if (this.exceptionStatus == null) {
            throw new IllegalFunctionException(ModbusFunctionCode.READ_EXCEPTION_STATUS.toInt());
        }
        return this.exceptionStatus.get();
    }

    public boolean[] readDiscreteInputRange(int offset, int quantity) throws IllegalDataAddressException, IllegalDataValueException {
        this.checkPointer(this.discreteInputs, offset);
        return this.discreteInputs.getRange(offset, quantity);
    }

    public ModbusFileRecord readFileRecord(ModbusFileRecord fileRecord) throws IllegalDataAddressException, IllegalDataValueException {
        ModbusFile file = this.getFile(fileRecord.getFileNumber());
        this.checkPointer(file, fileRecord.getFileNumber());
        fileRecord.writeRegisters(file.read(fileRecord.getRecordNumber(), fileRecord.getRecordLength()));
        return fileRecord;
    }

    public void writeFileRecord(ModbusFileRecord fileRecord) throws IllegalDataAddressException, IllegalDataValueException {
        ModbusFile file = this.getFile(fileRecord.getFileNumber());
        this.checkPointer(file, fileRecord.getFileNumber());
        file.write(fileRecord.getRecordNumber(), fileRecord.getRegisters());
    }

    public Coils getCoils() {
        return this.coils;
    }

    public void setCoils(Coils coils) {
        this.coils = coils;
    }

    public Coils getDiscreteInputs() {
        return this.discreteInputs;
    }

    public void setDiscreteInputs(Coils discreteInputs) {
        this.discreteInputs = discreteInputs;
    }

    public HoldingRegisters getHoldingRegisters() {
        return this.holdingRegisters;
    }

    public void setHoldingRegisters(HoldingRegisters holdingRegisters) {
        this.holdingRegisters = holdingRegisters;
    }

    public HoldingRegisters getInputRegisters() {
        return this.inputRegisters;
    }

    public void setInputRegisters(HoldingRegisters inputRegisters) {
        this.inputRegisters = inputRegisters;
    }

    public CommStatus getCommStatus() {
        return this.commStatus;
    }

    public SlaveId getSlaveId() {
        return this.slaveId;
    }

    public void setSlaveId(SlaveId slaveId) {
        this.slaveId = slaveId;
    }

    public ExceptionStatus getExceptionStatus() {
        return this.exceptionStatus;
    }

    public void setExceptionStatus(ExceptionStatus exceptionStatus) {
        this.exceptionStatus = exceptionStatus;
    }

    public FifoQueue getFifoQueue(int fifoPointerAddress) throws IllegalDataAddressException {
        FifoQueue file = this.fifoMap.get(fifoPointerAddress);
        if (file == null) {
            throw new IllegalDataAddressException(fifoPointerAddress);
        }
        return file;
    }

    public void addFifoQueue(FifoQueue fifoQueue, int fifoPointerAddress) throws IllegalDataAddressException {
        if (this.fifoMap.containsKey(fifoPointerAddress)) {
            throw new IllegalDataAddressException(fifoPointerAddress);
        }
        this.fifoMap.put(fifoPointerAddress, fifoQueue);
    }

    public void addFile(ModbusFile file) throws IllegalDataAddressException {
        if (this.fileMap.containsKey(file.getNumber())) {
            throw new IllegalDataAddressException(file.getNumber());
        }
        this.fileMap.put(file.getNumber(), file);
    }

    public ModbusFile getFile(int number) throws IllegalDataAddressException {
        ModbusFile file = this.fileMap.get(number);
        if (file == null) {
            throw new IllegalDataAddressException(number);
        }
        return file;
    }

    public ReadDeviceIdentificationInterface getReadDeviceIdentificationInterface() {
        return this.readDeviceIdentificationInterface;
    }

    public void setReadDeviceIdentificationInterface(ReadDeviceIdentificationInterface readDeviceIdentificationInterface) {
        this.readDeviceIdentificationInterface = readDeviceIdentificationInterface;
    }
}

