/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus;

import com.invertor.modbus.Modbus;
import com.invertor.modbus.data.CommStatus;
import com.invertor.modbus.exception.ModbusIOException;
import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.exception.ModbusProtocolException;
import com.invertor.modbus.msg.ModbusRequestFactory;
import com.invertor.modbus.msg.base.ModbusFileRecord;
import com.invertor.modbus.msg.base.ModbusMessage;
import com.invertor.modbus.msg.base.ModbusRequest;
import com.invertor.modbus.msg.base.ModbusResponse;
import com.invertor.modbus.msg.base.mei.MEIReadDeviceIdentification;
import com.invertor.modbus.msg.base.mei.ReadDeviceIdentificationCode;
import com.invertor.modbus.msg.response.EncapsulatedInterfaceTransportResponse;
import com.invertor.modbus.msg.response.ReadCoilsResponse;
import com.invertor.modbus.msg.response.ReadDiscreteInputsResponse;
import com.invertor.modbus.msg.response.ReadFifoQueueResponse;
import com.invertor.modbus.msg.response.ReadFileRecordResponse;
import com.invertor.modbus.msg.response.ReadHoldingRegistersResponse;
import com.invertor.modbus.msg.response.ReadInputRegistersResponse;
import com.invertor.modbus.msg.response.ReadWriteMultipleRegistersResponse;
import com.invertor.modbus.net.ModbusConnection;
import com.invertor.modbus.net.transport.ModbusTransport;
import com.invertor.modbus.utils.ModbusExceptionCode;

public abstract class ModbusMaster {
    protected final ModbusRequestFactory requestFactory = ModbusRequestFactory.getInstance();
    private int transactionId = 0;
    private long requestTime = 0L;
    private boolean connected = false;

    protected ModbusMaster() {
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(int transactionId) {
        this.transactionId = Math.min(Math.abs(transactionId), 65535);
    }

    protected abstract ModbusConnection getConnection();

    protected void connectImpl() throws ModbusIOException {
        this.getConnection().open();
    }

    protected void disconnectImpl() throws ModbusIOException {
        this.getConnection().close();
    }

    public final void connect() throws ModbusIOException {
        if (!this.isConnected()) {
            this.connectImpl();
            this.setConnected(true);
        }
    }

    public final void disconnect() throws ModbusIOException {
        if (this.isConnected()) {
            this.disconnectImpl();
            this.setConnected(false);
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    protected void setConnected(boolean connected) {
        this.connected = connected;
    }

    protected void sendRequest(ModbusMessage msg) throws ModbusIOException {
        ModbusTransport transport = this.getConnection().getTransport();
        if (transport == null) {
            throw new ModbusIOException("transport is null");
        }
        transport.send(msg);
        this.requestTime = System.currentTimeMillis();
    }

    protected ModbusMessage readResponse() throws ModbusProtocolException, ModbusNumberException, ModbusIOException {
        return this.getConnection().getTransport().readResponse();
    }

    public ModbusResponse processRequest(ModbusRequest request) throws ModbusProtocolException, ModbusNumberException, ModbusIOException {
        this.sendRequest(request);
        do {
            try {
                ModbusResponse msg = (ModbusResponse)this.readResponse();
                request.validateResponse(msg);
                if (msg.getModbusExceptionCode() != ModbusExceptionCode.ACKNOWLEDGE) {
                    if (msg.isException()) {
                        throw new ModbusProtocolException(msg.getModbusExceptionCode());
                    }
                    return msg;
                }
            }
            catch (ModbusNumberException mne) {
                Modbus.log().warning(mne.getLocalizedMessage());
            }
        } while (System.currentTimeMillis() - this.requestTime < (long)this.getConnection().getReadTimeout());
        throw new ModbusIOException("Response timeout.");
    }

    public void setResponseTimeout(int timeout) {
        try {
            this.getConnection().setReadTimeout(timeout);
        }
        catch (Exception e) {
            Modbus.log().warning(e.getLocalizedMessage());
        }
    }

    public final synchronized int[] readHoldingRegisters(int serverAddress, int startAddress, int quantity) throws ModbusProtocolException, ModbusNumberException, ModbusIOException {
        ModbusRequest request = this.requestFactory.createReadHoldingRegisters(serverAddress, startAddress, quantity);
        ReadHoldingRegistersResponse response = (ReadHoldingRegistersResponse)this.processRequest(request);
        return response.getRegisters();
    }

    public final synchronized int[] readInputRegisters(int serverAddress, int startAddress, int quantity) throws ModbusProtocolException, ModbusNumberException, ModbusIOException {
        ModbusRequest request = this.requestFactory.createReadInputRegisters(serverAddress, startAddress, quantity);
        ReadInputRegistersResponse response = (ReadInputRegistersResponse)this.processRequest(request);
        return response.getRegisters();
    }

    public final synchronized boolean[] readCoils(int serverAddress, int startAddress, int quantity) throws ModbusProtocolException, ModbusNumberException, ModbusIOException {
        ModbusRequest request = this.requestFactory.createReadCoils(serverAddress, startAddress, quantity);
        ReadCoilsResponse response = (ReadCoilsResponse)this.processRequest(request);
        return response.getCoils();
    }

    public final synchronized boolean[] readDiscreteInputs(int serverAddress, int startAddress, int quantity) throws ModbusProtocolException, ModbusNumberException, ModbusIOException {
        ModbusRequest request = this.requestFactory.createReadDiscreteInputs(serverAddress, startAddress, quantity);
        ReadDiscreteInputsResponse response = (ReadDiscreteInputsResponse)this.processRequest(request);
        return response.getCoils();
    }

    public final synchronized void writeSingleCoil(int serverAddress, int startAddress, boolean flag) throws ModbusProtocolException, ModbusNumberException, ModbusIOException {
        this.processRequest(this.requestFactory.createWriteSingleCoil(serverAddress, startAddress, flag));
    }

    public final synchronized void writeSingleRegister(int serverAddress, int startAddress, int register) throws ModbusProtocolException, ModbusNumberException, ModbusIOException {
        this.processRequest(this.requestFactory.createWriteSingleRegister(serverAddress, startAddress, register));
    }

    public final synchronized void writeMultipleCoils(int serverAddress, int startAddress, boolean[] coils) throws ModbusProtocolException, ModbusNumberException, ModbusIOException {
        this.processRequest(this.requestFactory.createWriteMultipleCoils(serverAddress, startAddress, coils));
    }

    public final synchronized void writeMultipleRegisters(int serverAddress, int startAddress, int[] registers) throws ModbusProtocolException, ModbusNumberException, ModbusIOException {
        this.processRequest(this.requestFactory.createWriteMultipleRegisters(serverAddress, startAddress, registers));
    }

    public final synchronized int[] readWriteMultipleRegisters(int serverAddress, int readAddress, int readQuantity, int writeAddress, int[] registers) throws ModbusProtocolException, ModbusNumberException, ModbusIOException {
        ModbusRequest request = this.requestFactory.createReadWriteMultipleRegisters(serverAddress, readAddress, readQuantity, writeAddress, registers);
        ReadWriteMultipleRegistersResponse response = (ReadWriteMultipleRegistersResponse)this.processRequest(request);
        return response.getRegisters();
    }

    public final synchronized int[] readFifoQueue(int serverAddress, int fifoPointerAddress) throws ModbusProtocolException, ModbusNumberException, ModbusIOException {
        ModbusRequest request = this.requestFactory.createReadFifoQueue(serverAddress, fifoPointerAddress);
        ReadFifoQueueResponse response = (ReadFifoQueueResponse)this.processRequest(request);
        return response.getFifoValueRegister();
    }

    public final synchronized ModbusFileRecord[] readFileRecord(int serverAddress, ModbusFileRecord[] records) throws ModbusProtocolException, ModbusNumberException, ModbusIOException {
        ModbusRequest request = this.requestFactory.createReadFileRecord(serverAddress, records);
        ReadFileRecordResponse response = (ReadFileRecordResponse)this.processRequest(request);
        return response.getFileRecords();
    }

    public final synchronized void writeFileRecord(int serverAddress, ModbusFileRecord record) throws ModbusProtocolException, ModbusNumberException, ModbusIOException {
        this.processRequest(this.requestFactory.createWriteFileRecord(serverAddress, record));
    }

    public final synchronized void maskWriteRegister(int serverAddress, int startAddress, int and, int or) throws ModbusProtocolException, ModbusNumberException, ModbusIOException {
        this.processRequest(this.requestFactory.createMaskWriteRegister(serverAddress, startAddress, and, or));
    }

    public abstract int readExceptionStatus(int var1) throws ModbusProtocolException, ModbusNumberException, ModbusIOException;

    public abstract byte[] reportSlaveId(int var1) throws ModbusProtocolException, ModbusNumberException, ModbusIOException;

    public abstract CommStatus getCommEventCounter(int var1) throws ModbusProtocolException, ModbusNumberException, ModbusIOException;

    public abstract CommStatus getCommEventLog(int var1) throws ModbusProtocolException, ModbusNumberException, ModbusIOException;

    public abstract void diagnosticsReturnQueryData(int var1, int var2) throws ModbusNumberException, ModbusProtocolException, ModbusIOException;

    public abstract void diagnosticsRestartCommunicationsOption(int var1, boolean var2) throws ModbusNumberException, ModbusProtocolException, ModbusIOException;

    public abstract int diagnosticsReturnDiagnosticRegister(int var1) throws ModbusNumberException, ModbusProtocolException, ModbusIOException;

    public abstract void diagnosticsChangeAsciiInputDelimiter(int var1, int var2) throws ModbusNumberException, ModbusProtocolException, ModbusIOException;

    public abstract void diagnosticsForceListenOnlyMode(int var1) throws ModbusNumberException, ModbusProtocolException, ModbusIOException;

    public abstract void diagnosticsClearCountersAndDiagnosticRegister(int var1) throws ModbusNumberException, ModbusProtocolException, ModbusIOException;

    public abstract int diagnosticsReturnBusMessageCount(int var1) throws ModbusNumberException, ModbusProtocolException, ModbusIOException;

    public abstract int diagnosticsReturnBusCommunicationErrorCount(int var1) throws ModbusNumberException, ModbusProtocolException, ModbusIOException;

    public abstract int diagnosticsReturnBusExceptionErrorCount(int var1) throws ModbusNumberException, ModbusProtocolException, ModbusIOException;

    public abstract int diagnosticsReturnSlaveMessageCount(int var1) throws ModbusNumberException, ModbusProtocolException, ModbusIOException;

    public abstract int diagnosticsReturnSlaveNoResponseCount(int var1) throws ModbusNumberException, ModbusProtocolException, ModbusIOException;

    public abstract int diagnosticsReturnSlaveNAKCount(int var1) throws ModbusNumberException, ModbusProtocolException, ModbusIOException;

    public abstract int diagnosticsReturnSlaveBusyCount(int var1) throws ModbusNumberException, ModbusProtocolException, ModbusIOException;

    public abstract int diagnosticsReturnBusCharacterOverrunCount(int var1) throws ModbusNumberException, ModbusProtocolException, ModbusIOException;

    public abstract void diagnosticsClearOverrunCounterAndFlag(int var1) throws ModbusNumberException, ModbusProtocolException, ModbusIOException;

    public final MEIReadDeviceIdentification readDeviceIdentification(int serverAddress, int objectId, ReadDeviceIdentificationCode readDeviceId) throws ModbusProtocolException, ModbusNumberException, ModbusIOException {
        EncapsulatedInterfaceTransportResponse response = (EncapsulatedInterfaceTransportResponse)this.processRequest(this.requestFactory.createReadDeviceIdentification(serverAddress, objectId, readDeviceId));
        return (MEIReadDeviceIdentification)response.getMei();
    }
}

