/*
 * Decompiled with CFR 0.152.
 */
package com.dumbster.smtp;

import com.dumbster.smtp.SmtpResponse;
import com.dumbster.smtp.SmtpState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SmtpMessage {
    private Map<String, List<String>> headers = new LinkedHashMap<String, List<String>>(10);
    private StringBuilder body = new StringBuilder();

    public void store(SmtpResponse response, String params) {
        if (params != null) {
            if (SmtpState.DATA_HDR.equals(response.getNextState())) {
                int headerNameEnd = params.indexOf(58);
                if (headerNameEnd >= 0) {
                    String name = params.substring(0, headerNameEnd).trim();
                    String value = params.substring(headerNameEnd + 1).trim();
                    this.addHeader(name, value);
                }
            } else if (SmtpState.DATA_BODY == response.getNextState()) {
                this.body.append(params);
            }
        }
    }

    public Set<String> getHeaderNames() {
        return Collections.unmodifiableSet(new LinkedHashSet<String>(this.headers.keySet()));
    }

    public List<String> getHeaderValues(String name) {
        List<String> values = this.headers.get(name);
        if (values == null || values.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<String>(values));
    }

    public String getHeaderValue(String name) {
        List<String> values = this.headers.get(name);
        if (values == null) {
            return null;
        }
        return values.get(0);
    }

    public String getBody() {
        return this.body.toString();
    }

    private void addHeader(String name, String value) {
        List<String> valueList = this.headers.get(name);
        if (valueList == null) {
            valueList = new ArrayList<String>(1);
            this.headers.put(name, valueList);
        }
        valueList.add(value);
    }

    public String toString() {
        StringBuilder msg = new StringBuilder();
        for (Map.Entry<String, List<String>> stringListEntry : this.headers.entrySet()) {
            for (String value : stringListEntry.getValue()) {
                msg.append(stringListEntry.getKey());
                msg.append(": ");
                msg.append(value);
                msg.append('\n');
            }
        }
        msg.append('\n');
        msg.append((CharSequence)this.body);
        msg.append('\n');
        return msg.toString();
    }
}

