/*
 * Decompiled with CFR 0.152.
 */
package com.dumbster.smtp;

import com.dumbster.smtp.SmtpActionType;
import com.dumbster.smtp.SmtpMessage;
import com.dumbster.smtp.SmtpRequest;
import com.dumbster.smtp.SmtpResponse;
import com.dumbster.smtp.SmtpState;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SimpleSmtpServer
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(SimpleSmtpServer.class);
    public static final int DEFAULT_SMTP_PORT = 25;
    public static final int AUTO_SMTP_PORT = 0;
    private static final int STOP_TIMEOUT = 20000;
    private static final Pattern CRLF = Pattern.compile("\r\n");
    private final List<SmtpMessage> receivedMail = new ArrayList<SmtpMessage>();
    private final ServerSocket serverSocket;
    private final Thread workerThread;
    private volatile boolean stopped = false;

    public static SimpleSmtpServer start(int port) throws IOException {
        return new SimpleSmtpServer(new ServerSocket(Math.max(port, 0)));
    }

    private SimpleSmtpServer(ServerSocket serverSocket) {
        this.serverSocket = serverSocket;
        this.workerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                SimpleSmtpServer.this.performWork();
            }
        });
        this.workerThread.start();
    }

    public int getPort() {
        return this.serverSocket.getLocalPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SmtpMessage> getReceivedEmails() {
        List<SmtpMessage> list = this.receivedMail;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<SmtpMessage>(this.receivedMail));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        List<SmtpMessage> list = this.receivedMail;
        synchronized (list) {
            this.receivedMail.clear();
        }
    }

    public void stop() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            log.warn("trouble closing the server socket", (Throwable)e);
        }
        try {
            this.workerThread.join(20000L);
        }
        catch (InterruptedException e) {
            log.warn("interrupted when waiting for worker thread to finish", (Throwable)e);
        }
    }

    @Override
    public void close() {
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void performWork() {
        try {
            while (!this.stopped) {
                Socket socket;
                block41: {
                    socket = this.serverSocket.accept();
                    Throwable throwable = null;
                    try {
                        try (Scanner input = new Scanner(new InputStreamReader(socket.getInputStream(), StandardCharsets.ISO_8859_1)).useDelimiter(CRLF);
                             PrintWriter out = new PrintWriter(new OutputStreamWriter(socket.getOutputStream(), StandardCharsets.ISO_8859_1));){
                            List<SmtpMessage> list = this.receivedMail;
                            synchronized (list) {
                                this.receivedMail.addAll(SimpleSmtpServer.handleTransaction(out, input));
                            }
                        }
                        if (socket == null) continue;
                        if (throwable == null) break block41;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (socket == null) throw throwable3;
                            if (throwable == null) {
                                socket.close();
                                throw throwable3;
                            }
                            try {
                                socket.close();
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                                throw throwable3;
                            }
                        }
                    }
                    try {
                        socket.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                socket.close();
            }
            return;
        }
        catch (Exception e) {
            if (this.stopped) return;
            log.error("hit exception when running server", (Throwable)e);
            try {
                this.serverSocket.close();
                return;
            }
            catch (IOException ex) {
                log.error("and one when closing the port", (Throwable)ex);
            }
        }
    }

    private static List<SmtpMessage> handleTransaction(PrintWriter out, Iterator<String> input) throws IOException {
        String line;
        SmtpState smtpState = SmtpState.CONNECT;
        SmtpRequest smtpRequest = new SmtpRequest(SmtpActionType.CONNECT, "", smtpState);
        SmtpResponse smtpResponse = smtpRequest.execute();
        SimpleSmtpServer.sendResponse(out, smtpResponse);
        smtpState = smtpResponse.getNextState();
        ArrayList<SmtpMessage> msgList = new ArrayList<SmtpMessage>();
        SmtpMessage msg = new SmtpMessage();
        while (smtpState != SmtpState.CONNECT && (line = input.next()) != null) {
            SmtpRequest request = SmtpRequest.createRequest(line, smtpState);
            SmtpResponse response = request.execute();
            smtpState = response.getNextState();
            SimpleSmtpServer.sendResponse(out, response);
            String params = request.params;
            msg.store(response, params);
            if (smtpState != SmtpState.QUIT) continue;
            msgList.add(msg);
            msg = new SmtpMessage();
        }
        return msgList;
    }

    private static void sendResponse(PrintWriter out, SmtpResponse smtpResponse) {
        if (smtpResponse.getCode() > 0) {
            int code = smtpResponse.getCode();
            String message = smtpResponse.getMessage();
            out.print(code + " " + message + "\r\n");
            out.flush();
        }
    }
}

