/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.pcg.fast;

import com.github.kilianB.pcg.Pcg;
import java.lang.reflect.InvocationTargetException;
import java.util.Random;

public class PcgRSFast
extends Random
implements Pcg {
    private static final long serialVersionUID = -4257915988930727506L;
    private static final long MULT_64 = 6364136223846793005L;
    private static final double DOUBLE_MASK = 9.007199254740992E15;
    private static final float FLOAT_UNIT = 1.6777216E7f;
    private static final long INTEGER_MASK = 0xFFFFFFFFL;
    protected long state;
    protected long inc;
    private boolean gausAvailable;
    private double nextGaus;

    public PcgRSFast() {
        this(PcgRSFast.getRandomSeed(), PcgRSFast.getRandomSeed());
    }

    public PcgRSFast(long seed, long streamNumber) {
        this.setSeed(seed, streamNumber);
    }

    protected PcgRSFast(long initialState, long increment, boolean dummy) {
        this.setState(initialState);
        this.setInc(increment);
    }

    public void setSeed(long seed, long streamNumber) {
        this.state = 0L;
        this.inc = streamNumber << 1 | 1L;
        this.state = this.state * 6364136223846793005L + this.inc;
        this.state += seed;
    }

    @Override
    public void advance(long steps) {
        long acc_mult = 1L;
        long acc_plus = 0L;
        long cur_plus = this.inc;
        long cur_mult = 6364136223846793005L;
        while (Long.compareUnsigned(steps, 0L) > 0) {
            if ((steps & 1L) == 1L) {
                acc_mult *= cur_mult;
                acc_plus = acc_plus * cur_mult + cur_plus;
            }
            cur_plus *= cur_mult + 1L;
            cur_mult *= cur_mult;
            steps = Long.divideUnsigned(steps, 2L);
        }
        this.state = acc_mult * this.state + acc_plus;
    }

    @Override
    public byte nextByte() {
        this.state = this.state * 6364136223846793005L + this.inc;
        return (byte)((this.state >>> 22 ^ this.state) >>> (int)((this.state >>> 61) + 22L) >>> 24);
    }

    @Override
    public void nextBytes(byte[] b) {
        for (int i = 0; i < b.length; ++i) {
            this.state = this.state * 6364136223846793005L + this.inc;
            b[i] = (byte)((this.state >>> 22 ^ this.state) >>> (int)((this.state >>> 61) + 22L) >>> 24);
        }
    }

    @Override
    public char nextChar() {
        this.state = this.state * 6364136223846793005L + this.inc;
        return (char)((this.state >>> 22 ^ this.state) >>> (int)((this.state >>> 61) + 22L) >>> 16);
    }

    @Override
    public short nextShort() {
        this.state = this.state * 6364136223846793005L + this.inc;
        return (short)((this.state >>> 22 ^ this.state) >>> (int)((this.state >>> 61) + 22L) >>> 16);
    }

    @Override
    public int nextInt() {
        this.state = this.state * 6364136223846793005L + this.inc;
        return (int)((this.state >>> 22 ^ this.state) >>> (int)((this.state >>> 61) + 22L));
    }

    @Override
    public int nextInt(int n) {
        this.state = this.state * 6364136223846793005L + this.inc;
        int r = (int)((this.state >>> 22 ^ this.state) >>> (int)((this.state >>> 61) + 22L)) >>> 1;
        int m = n - 1;
        if ((n & m) == 0) {
            r = (int)((long)n * (long)r >> 31);
        } else {
            int u = r;
            while (u - (r = u % n) + m < 0) {
                this.state = this.state * 6364136223846793005L + this.inc;
                u = (int)((this.state >>> 22 ^ this.state) >>> (int)((this.state >>> 61) + 22L)) >>> 1;
            }
        }
        return r;
    }

    @Override
    public boolean nextBoolean() {
        this.state = this.state * 6364136223846793005L + this.inc;
        return ((this.state >>> 22 ^ this.state) >>> (int)((this.state >>> 61) + 22L) & 0xFFFFFFFFL) >>> 31 != 0L;
    }

    @Override
    public boolean nextBoolean(double probability) {
        if (probability < 0.0 || probability > 1.0) {
            throw new IllegalArgumentException("probability must be between 0.0 and 1.0 inclusive.");
        }
        if (probability == 0.0) {
            return false;
        }
        if (probability == 1.0) {
            return true;
        }
        this.state = this.state * 6364136223846793005L + this.inc;
        long l = (this.state >>> 22 ^ this.state) >>> (int)((this.state >>> 61) + 22L) & 0xFFFFFFFFL;
        this.state = this.state * 6364136223846793005L + this.inc;
        return (double)((l >>> 6 << 27) + (((this.state >>> 22 ^ this.state) >>> (int)((this.state >>> 61) + 22L) & 0xFFFFFFFFL) >>> 5)) / 9.007199254740992E15 < probability;
    }

    @Override
    public long nextLong() {
        this.state = this.state * 6364136223846793005L + this.inc;
        long l = (this.state >>> 22 ^ this.state) >>> (int)((this.state >>> 61) + 22L);
        this.state = this.state * 6364136223846793005L + this.inc;
        long j = (this.state >>> 22 ^ this.state) >>> (int)((this.state >>> 61) + 22L);
        return (l << 32) + (long)((int)j);
    }

    @Override
    public long nextLong(long n) {
        long val;
        long j;
        long l;
        long bits;
        if (n == 0L) {
            throw new IllegalArgumentException("n has to be greater than 0");
        }
        do {
            this.state = this.state * 6364136223846793005L + this.inc;
            l = (this.state >>> 22 ^ this.state) >>> (int)((this.state >>> 61) + 22L);
            this.state = this.state * 6364136223846793005L + this.inc;
        } while ((bits = (l << 32) + (long)((int)(j = (this.state >>> 22 ^ this.state) >>> (int)((this.state >>> 61) + 22L))) >>> 1) - (val = bits % n) + (n - 1L) < 0L);
        return val;
    }

    @Override
    public double nextDouble() {
        this.state = this.state * 6364136223846793005L + this.inc;
        long l = (this.state >>> 22 ^ this.state) >>> (int)((this.state >>> 61) + 22L) & 0xFFFFFFFFL;
        this.state = this.state * 6364136223846793005L + this.inc;
        return (double)((l >>> 6 << 27) + (((this.state >>> 22 ^ this.state) >>> (int)((this.state >>> 61) + 22L) & 0xFFFFFFFFL) >>> 5)) / 9.007199254740992E15;
    }

    @Override
    public double nextDouble(boolean includeZero, boolean includeOne) {
        double d = 0.0;
        do {
            this.state = this.state * 6364136223846793005L + this.inc;
            long l = (this.state >>> 22 ^ this.state) >>> (int)((this.state >>> 61) + 22L) & 0xFFFFFFFFL;
            this.state = this.state * 6364136223846793005L + this.inc;
            d = (double)((l >>> 6 << 27) + (((this.state >>> 22 ^ this.state) >>> (int)((this.state >>> 61) + 22L) & 0xFFFFFFFFL) >>> 5)) / 9.007199254740992E15;
            if (!includeOne) continue;
            this.state = this.state * 6364136223846793005L + this.inc;
            if (((this.state >>> 22 ^ this.state) >>> (int)((this.state >>> 61) + 22L) & 0xFFFFFFFFL) >>> 31 == 0L) continue;
            d += 1.0;
        } while (d > 1.0 || !includeZero && d == 0.0);
        return d;
    }

    @Override
    public float nextFloat() {
        this.state = this.state * 6364136223846793005L + this.inc;
        return (float)(((this.state >>> 22 ^ this.state) >>> (int)((this.state >>> 61) + 22L) & 0xFFFFFFFFL) >>> 8) / 1.6777216E7f;
    }

    @Override
    public float nextFloat(boolean includeZero, boolean includeOne) {
        float d = 0.0f;
        do {
            this.state = this.state * 6364136223846793005L + this.inc;
            d = (float)(((this.state >>> 22 ^ this.state) >>> (int)((this.state >>> 61) + 22L) & 0xFFFFFFFFL) >>> 8) / 1.6777216E7f;
            if (!includeOne) continue;
            this.state = this.state * 6364136223846793005L + this.inc;
            if (((this.state >>> 22 ^ this.state) >>> (int)((this.state >>> 61) + 22L) & 0xFFFFFFFFL) >>> 31 == 0L) continue;
            d += 1.0f;
        } while (d > 1.0f || !includeZero && d == 0.0f);
        return d;
    }

    @Override
    public double nextGaussian() {
        double v2;
        double v1;
        double s;
        if (this.gausAvailable) {
            this.gausAvailable = false;
            return this.nextGaus;
        }
        while ((s = (v1 = 2.0 * this.nextDouble() - 1.0) * v1 + (v2 = 2.0 * this.nextDouble() - 1.0) * v2) >= 1.0 || s == 0.0) {
        }
        double multiplier = StrictMath.sqrt(-2.0 * StrictMath.log(s) / s);
        this.nextGaus = v2 * multiplier;
        this.gausAvailable = true;
        return v1 * multiplier;
    }

    @Override
    public long getInc() {
        return this.inc;
    }

    @Override
    public long getState() {
        return this.state;
    }

    protected void setInc(long increment) {
        if (increment == 0L || increment % 2L == 0L) {
            throw new IllegalArgumentException("Increment may not be 0 or even. Value: " + increment);
        }
        this.inc = increment;
    }

    protected void setState(long state) {
        this.state = state;
    }

    @Override
    public <T> T split() throws ReflectiveOperationException {
        try {
            return (T)this.getClass().getDeclaredConstructor(Long.TYPE, Long.TYPE, Boolean.TYPE).newInstance(this.getState(), this.getInc(), true);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            e.getCause().printStackTrace();
            throw new ReflectiveOperationException("Failed to instantiate clone constructor");
        }
    }

    @Override
    public <T> T splitDistinct() throws ReflectiveOperationException {
        try {
            long curState;
            long curInc;
            while ((curInc = (this.nextLong(Math.abs(this.getInc())) ^ (System.nanoTime() ^ 0xFFFFFFFFFFFFFFFFL)) * 2L + 1L) == this.getInc()) {
            }
            while ((curState = this.nextLong(Math.abs(this.getState())) ^ (System.nanoTime() ^ 0xFFFFFFFFFFFFFFFFL)) == this.getState()) {
            }
            return (T)this.getClass().getDeclaredConstructor(Long.TYPE, Long.TYPE, Boolean.TYPE).newInstance(curState, curInc, true);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            e.getCause().printStackTrace();
            throw new ReflectiveOperationException("Failed to instantiate clone constructor");
        }
    }

    @Override
    public int next(int n) {
        throw new UnsupportedOperationException("Fast methods don't implement next method");
    }

    @Override
    public long getMult() {
        return 6364136223846793005L;
    }

    @Override
    public boolean isFast() {
        return true;
    }

    protected static long getRandomSeed() {
        long next;
        long current;
        do {
            next = current = UNIQUE_SEED.get();
            next ^= next >> 12;
            next ^= next << 25;
            next ^= next >> 27;
        } while (!UNIQUE_SEED.compareAndSet(current, next *= 2685821657736338717L));
        return next;
    }
}

