/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.sensitive.word.support.check;

import com.github.houbb.heaven.support.pipeline.Pipeline;
import com.github.houbb.heaven.util.util.ArrayUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import com.github.houbb.sensitive.word.api.IWordCheck;
import com.github.houbb.sensitive.word.api.IWordContext;
import com.github.houbb.sensitive.word.support.check.WordCheckEmail;
import com.github.houbb.sensitive.word.support.check.WordCheckInit;
import com.github.houbb.sensitive.word.support.check.WordCheckNone;
import com.github.houbb.sensitive.word.support.check.WordCheckNum;
import com.github.houbb.sensitive.word.support.check.WordCheckUrl;
import com.github.houbb.sensitive.word.support.check.WordCheckWord;
import java.util.ArrayList;
import java.util.Collection;

public final class WordChecks {
    private WordChecks() {
    }

    public static IWordCheck initSensitiveCheck(IWordContext context) {
        ArrayList<IWordCheck> sensitiveCheckList = new ArrayList<IWordCheck>();
        if (context.enableWordCheck()) {
            sensitiveCheckList.add(WordChecks.word());
        }
        if (context.enableNumCheck()) {
            sensitiveCheckList.add(WordChecks.num());
        }
        if (context.enableEmailCheck()) {
            sensitiveCheckList.add(WordChecks.email());
        }
        if (context.enableUrlCheck()) {
            sensitiveCheckList.add(WordChecks.url());
        }
        return WordChecks.chains(sensitiveCheckList);
    }

    public static IWordCheck chains(final IWordCheck ... sensitiveChecks) {
        if (ArrayUtil.isEmpty((Object[])sensitiveChecks)) {
            return WordChecks.none();
        }
        return new WordCheckInit(){

            @Override
            protected void init(Pipeline<IWordCheck> pipeline) {
                for (IWordCheck check : sensitiveChecks) {
                    pipeline.addLast((Object)check);
                }
            }
        };
    }

    public static IWordCheck chains(final Collection<IWordCheck> sensitiveChecks) {
        if (CollectionUtil.isEmpty(sensitiveChecks)) {
            return WordChecks.none();
        }
        return new WordCheckInit(){

            @Override
            protected void init(Pipeline<IWordCheck> pipeline) {
                for (IWordCheck check : sensitiveChecks) {
                    pipeline.addLast((Object)check);
                }
            }
        };
    }

    public static IWordCheck email() {
        return WordCheckEmail.getInstance();
    }

    public static IWordCheck num() {
        return WordCheckNum.getInstance();
    }

    public static IWordCheck url() {
        return WordCheckUrl.getInstance();
    }

    public static IWordCheck word() {
        return WordCheckWord.getInstance();
    }

    public static IWordCheck none() {
        return WordCheckNone.getInstance();
    }
}

