/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.pinyin.api.impl;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.support.handler.IHandler;
import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import com.github.houbb.pinyin.api.IPinyin;
import com.github.houbb.pinyin.api.IPinyinContext;
import com.github.houbb.pinyin.spi.IPinyinChinese;
import com.github.houbb.pinyin.spi.IPinyinData;
import com.github.houbb.pinyin.spi.IPinyinSegment;
import com.github.houbb.pinyin.spi.IPinyinTone;
import java.util.Collections;
import java.util.List;

@ThreadSafe
public class Pinyin
implements IPinyin {
    @Override
    public String toPinyin(String string, IPinyinContext context) {
        List<String> stringList = this.toPinyinList(string, context);
        return StringUtil.join(stringList, (String)" ");
    }

    @Override
    public List<String> toPinyinList(char chinese, IPinyinContext context) {
        String original = String.valueOf(chinese);
        IPinyinChinese pinyinChinese = context.chinese();
        IPinyinTone pinyinTone = context.tone();
        if (pinyinChinese.isChinese(original)) {
            String simple = pinyinChinese.toSimple(original);
            return pinyinTone.toneList(simple, context);
        }
        return Collections.singletonList(original);
    }

    @Override
    public boolean hasSamePinyin(char chineseOne, char chineseTwo, IPinyinContext context) {
        IPinyinChinese pinyinChinese = context.chinese();
        IPinyinTone pinyinTone = context.tone();
        if (pinyinChinese.isChinese(chineseOne) && pinyinChinese.isChinese(chineseTwo)) {
            if (chineseOne == chineseTwo) {
                return true;
            }
            String simpleOne = pinyinChinese.toSimple(chineseOne);
            String simpleTwo = pinyinChinese.toSimple(chineseTwo);
            List<String> tonesOne = pinyinTone.toneList(simpleOne, context);
            List<String> tonesTwo = pinyinTone.toneList(simpleTwo, context);
            return CollectionUtil.containAny(tonesOne, tonesTwo);
        }
        return false;
    }

    @Override
    public List<Integer> toneNumList(String chinese, IPinyinContext context) {
        List<String> pinyinList = this.toPinyinList(chinese, context);
        return this.buildToneNumList(pinyinList, context.tone());
    }

    @Override
    public List<Integer> toneNumList(char chinese, IPinyinContext context) {
        List<String> pinyinList = this.toPinyinList(chinese, context);
        return this.buildToneNumList(pinyinList, context.tone());
    }

    @Override
    public List<String> shengMuList(String chinese, IPinyinContext context) {
        final IPinyinData pinyinData = context.data();
        return this.normalPinyinHandler(chinese, context, new IHandler<String, String>(){

            public String handle(String s) {
                return pinyinData.shengMu(s);
            }
        });
    }

    @Override
    public List<String> yunMuList(String chinese, IPinyinContext context) {
        final IPinyinData pinyinData = context.data();
        return this.normalPinyinHandler(chinese, context, new IHandler<String, String>(){

            public String handle(String s) {
                return pinyinData.yunMu(s);
            }
        });
    }

    private List<String> toPinyinList(String string, IPinyinContext context) {
        if (StringUtil.isEmptyTrim((String)string)) {
            return Collections.emptyList();
        }
        IPinyinSegment pinyinSegment = context.segment();
        IPinyinChinese pinyinChinese = context.chinese();
        IPinyinTone pinyinTone = context.tone();
        List<String> entryList = pinyinSegment.segment(string);
        List resultList = Guavas.newArrayList((int)entryList.size());
        for (String entry : entryList) {
            if (StringUtil.isEmptyTrim((String)entry)) continue;
            if (pinyinChinese.isChinese(entry)) {
                String simple = pinyinChinese.toSimple(entry);
                String tone = pinyinTone.tone(simple, context);
                resultList.add(tone);
                continue;
            }
            resultList.add(entry);
        }
        return resultList;
    }

    private List<Integer> buildToneNumList(List<String> pinyinList, IPinyinTone pinyinTone) {
        List resultList = Guavas.newArrayList((int)pinyinList.size());
        for (String pinyin : pinyinList) {
            Integer toneNum = pinyinTone.toneNum(pinyin);
            resultList.add(toneNum);
        }
        return resultList;
    }

    private List<String> normalPinyinHandler(String chinese, IPinyinContext context, IHandler<String, String> handler) {
        List<String> pinyinList = this.toPinyinList(chinese, context);
        List resultList = Guavas.newArrayList((int)pinyinList.size());
        for (String pinyin : pinyinList) {
            String result = (String)handler.handle((Object)pinyin);
            resultList.add(result);
        }
        return resultList;
    }
}

