/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.util.util;

import com.github.houbb.heaven.util.codec.Base64;
import com.github.houbb.heaven.util.common.ArgUtil;
import java.text.DecimalFormat;

public final class NumUtil {
    private static final int[] DIGITS_INDEX = new int[128];

    private NumUtil() {
    }

    private static int getIndex(String s, int pos) {
        char c = s.charAt(pos);
        return DIGITS_INDEX[c];
    }

    public static long num64To10(String s) {
        long result = 0L;
        long multiplier = 1L;
        for (int pos = s.length() - 1; pos >= 0; --pos) {
            int index = NumUtil.getIndex(s, pos);
            result += (long)index * multiplier;
            multiplier *= 64L;
        }
        return result;
    }

    public static String num10To64(long number) {
        ArgUtil.notNegative(number, "number");
        if (number == 0L) {
            return "0";
        }
        StringBuilder buf = new StringBuilder();
        while (number != 0L) {
            int remain = (int)(number % 64L);
            char c = Base64.ALPHABET[remain];
            buf.append(c);
            number /= 64L;
        }
        return buf.reverse().toString();
    }

    public static String chainRatio(int before, int now) {
        if (before <= 0) {
            return "--";
        }
        double differ = (double)(now - before) * 1.0;
        double result = differ / ((double)before * 1.0) * 100.0;
        DecimalFormat numberFormat = new DecimalFormat("#0.00");
        return numberFormat.format(result);
    }

    static {
        for (int i = 0; i < 64; ++i) {
            NumUtil.DIGITS_INDEX[Base64.ALPHABET[i]] = i;
        }
    }
}

