/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.sj.loader.convert;

import java.util.Properties;
import org.osjava.datasource.SJDataSource;
import org.osjava.sj.loader.convert.ConverterIF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SJDataSourceConverter
implements ConverterIF {
    private static Logger LOGGER = LoggerFactory.getLogger(SJDataSourceConverter.class);

    @Override
    public Object convert(Properties properties, String type) {
        String driverName = properties.getProperty("driver");
        String url = properties.getProperty("url");
        String user = properties.getProperty("user");
        String password = properties.getProperty("password");
        if (driverName == null) {
            LOGGER.error("Incomplete arguments provided: properties={} type={}", (Object)properties, (Object)type);
            throw new IllegalArgumentException("Required subelement 'driver'");
        }
        if (url == null) {
            LOGGER.error("Incomplete arguments provided: properties={} type={}", (Object)properties, (Object)type);
            throw new IllegalArgumentException("Required subelement 'url'");
        }
        if (user == null) {
            LOGGER.error("Incomplete arguments provided: properties={} type={}", (Object)properties, (Object)type);
            throw new IllegalArgumentException("Required subelement 'user'");
        }
        if (password == null) {
            LOGGER.error("Incomplete arguments provided: properties={} type={}", (Object)properties, (Object)type);
            throw new IllegalArgumentException("Required subelement 'password'");
        }
        return new SJDataSource(driverName, url, user, password, properties);
    }
}

