/*
 * Decompiled with CFR 0.152.
 */
package com.gokuai.base;

import com.gokuai.base.utils.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SignAbility {
    static List<String> IGNORE_KEYS = Arrays.asList("filehash", "filesize", "sign");
    protected final String mClientId;
    protected final String mSecret;

    public SignAbility(String clientId, String secret) {
        this.mClientId = clientId;
        this.mSecret = secret;
    }

    public String getClientId() {
        return this.mClientId;
    }

    public String getSecret() {
        return this.mSecret;
    }

    protected String generateSign(HashMap<String, String> params, String secret) {
        Iterator<Map.Entry<String, String>> it = params.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> pair = it.next();
            if (pair.getValue() != null) continue;
            it.remove();
        }
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        String strToSign = "";
        if (!params.isEmpty()) {
            for (String key : keys) {
                if (IGNORE_KEYS.contains(key)) continue;
                String value = params.get(key);
                strToSign = strToSign + "\n" + value;
            }
            strToSign = strToSign.substring(1);
        }
        return Util.getHmacSha1(strToSign, secret);
    }

    protected String generateSign(HashMap<String, String> params) {
        return this.generateSign(params, this.mSecret);
    }
}

