/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.sortedsets;

import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.datastructures.RMZSet;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.datastructures.ZSetEntry;
import com.github.fppt.jedismock.datastructures.ZSetEntryBound;
import com.github.fppt.jedismock.exception.WrongValueTypeException;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractByScoreOperation
extends AbstractRedisOperation {
    protected static final String EXCLUSIVE_PREFIX = "(";
    private static final String LOWEST_POSSIBLE_SCORE = "-inf";
    private static final String HIGHEST_POSSIBLE_SCORE = "+inf";

    public AbstractByScoreOperation(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    private static double toDouble(String value) {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new WrongValueTypeException("Valid start must be a number or start with '(' or be equal to '-inf'");
        }
    }

    final ZSetEntryBound getStartBound(String start) {
        if (LOWEST_POSSIBLE_SCORE.equalsIgnoreCase(start)) {
            return ZSetEntryBound.MINUS_INF;
        }
        if (start.startsWith(EXCLUSIVE_PREFIX)) {
            return new ZSetEntryBound(AbstractByScoreOperation.toDouble(start.substring(1)), ZSetEntry.MAX_VALUE, false);
        }
        return new ZSetEntryBound(AbstractByScoreOperation.toDouble(start), ZSetEntry.MIN_VALUE, true);
    }

    final ZSetEntryBound getEndBound(String end) {
        if (HIGHEST_POSSIBLE_SCORE.equalsIgnoreCase(end)) {
            return ZSetEntryBound.PLUS_INF;
        }
        if (end.startsWith(EXCLUSIVE_PREFIX)) {
            return new ZSetEntryBound(AbstractByScoreOperation.toDouble(end.substring(1)), ZSetEntry.MIN_VALUE, false);
        }
        return new ZSetEntryBound(AbstractByScoreOperation.toDouble(end), ZSetEntry.MAX_VALUE, true);
    }

    final Slice rangeByScore(Slice start, Slice end, boolean rev) {
        Slice key = this.params().get(0);
        RMZSet mapDBObj = this.getZSetFromBaseOrCreateEmpty(key);
        if (mapDBObj.isEmpty()) {
            return Response.array(Collections.emptyList());
        }
        NavigableSet<ZSetEntry> subset = mapDBObj.subset(this.getStartBound(start.toString()), this.getEndBound(end.toString()));
        if (rev) {
            subset = subset.descendingSet();
        }
        Stream entries = subset.stream();
        boolean withScores = false;
        for (int i = 3; i < this.params().size(); ++i) {
            String param = this.params().get(i).toString();
            if ("withscores".equalsIgnoreCase(param)) {
                withScores = true;
                continue;
            }
            if (!"limit".equalsIgnoreCase(param)) continue;
            long offset = Utils.convertToLong(this.params().get(++i).toString());
            long count = Utils.convertToLong(this.params().get(++i).toString());
            entries = entries.skip(offset).limit(count);
        }
        Stream<Object> result = withScores ? entries.flatMap(e -> Stream.of(e.getValue(), Slice.create(Double.toString(e.getScore())))) : entries.map(ZSetEntry::getValue);
        List<Slice> list = result.map(Response::bulkString).collect(Collectors.toList());
        return Response.array(list);
    }
}

