/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.lists;

import com.github.fppt.jedismock.datastructures.RMList;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.exception.WrongValueTypeException;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.ArrayList;
import java.util.List;

abstract class ListPopper
extends AbstractRedisOperation {
    ListPopper(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    abstract Slice popper(List<Slice> var1);

    @Override
    protected final Slice response() {
        Slice key = this.params().get(0);
        RMList listDBObj = this.getListFromBaseOrCreateEmpty(key);
        List<Slice> list = listDBObj.getStoredData();
        if (list.isEmpty()) {
            return Response.NULL;
        }
        if (this.params().size() > 1) {
            Slice countParam = this.params().get(1);
            int count = Integer.parseInt(countParam.toString());
            if (count <= 0) {
                throw new WrongValueTypeException("value is out of range, must be positive");
            }
            ArrayList<Slice> responseList = new ArrayList<Slice>();
            while (count > 0 && list.size() > 0) {
                responseList.add(Response.bulkString(this.popper(list)));
                --count;
            }
            return Response.array(responseList);
        }
        return Response.bulkString(this.popper(list));
    }
}

