/*
 * Decompiled with CFR 0.152.
 */
package com.github.dadiyang.equator;

import com.github.dadiyang.equator.AbstractEquator;
import com.github.dadiyang.equator.FieldInfo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class GetterBaseEquator
extends AbstractEquator {
    private static final String GET = "get";
    private static final String IS = "is";
    private static final String GET_IS = "get|is";
    private static final String GET_CLASS = "getClass";
    private static final Map<Class<?>, Map<String, Method>> CACHE = new ConcurrentHashMap();

    public GetterBaseEquator() {
    }

    public GetterBaseEquator(boolean bothExistFieldOnly) {
        super(bothExistFieldOnly);
    }

    public GetterBaseEquator(List<String> includeFields, List<String> excludeFields) {
        super(includeFields, excludeFields);
    }

    public GetterBaseEquator(List<String> includeFields, List<String> excludeFields, boolean bothExistFieldOnly) {
        super(includeFields, excludeFields, bothExistFieldOnly);
    }

    @Override
    public List<FieldInfo> getDiffFields(Object first, Object second) {
        if (first == null && second == null) {
            return Collections.emptyList();
        }
        if (this.isSimpleField(first, second)) {
            return this.compareSimpleField(first, second);
        }
        Map<String, Method> firstGetters = this.getAllGetters(first);
        Map<String, Method> secondGetters = this.getAllGetters(second);
        Set<String> allFieldNames = first == null ? secondGetters.keySet() : (second == null ? firstGetters.keySet() : this.getAllFieldNames(firstGetters.keySet(), secondGetters.keySet()));
        LinkedList<FieldInfo> diffFields = new LinkedList<FieldInfo>();
        for (String fieldName : allFieldNames) {
            try {
                Method firstGetterMethod = firstGetters.getOrDefault(fieldName, null);
                Method secondGetterMethod = secondGetters.getOrDefault(fieldName, null);
                Object firstVal = firstGetterMethod != null ? firstGetterMethod.invoke(first, new Object[0]) : null;
                Object secondVal = secondGetterMethod != null ? secondGetterMethod.invoke(second, new Object[0]) : null;
                FieldInfo fieldInfo = new FieldInfo(fieldName, this.getReturnType(firstGetterMethod), this.getReturnType(secondGetterMethod));
                fieldInfo.setFirstVal(firstVal);
                fieldInfo.setSecondVal(secondVal);
                if (this.isFieldEquals(fieldInfo)) continue;
                diffFields.add(fieldInfo);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException("\u83b7\u53d6\u5c5e\u6027\u8fdb\u884c\u6bd4\u5bf9\u53d1\u751f\u5f02\u5e38: " + fieldName, e);
            }
        }
        return diffFields;
    }

    private Class<?> getReturnType(Method method) {
        return method == null ? null : method.getReturnType();
    }

    private Map<String, Method> getAllGetters(Object obj) {
        if (obj == null) {
            return Collections.emptyMap();
        }
        return CACHE.computeIfAbsent(obj.getClass(), k -> {
            LinkedHashMap<String, Method> getters = new LinkedHashMap<String, Method>(8);
            for (Class<?> clazz = obj.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
                Method[] methods;
                for (Method m : methods = clazz.getDeclaredMethods()) {
                    String fieldName;
                    if (!Modifier.isPublic(m.getModifiers()) || m.getParameterTypes().length > 0) continue;
                    if ((m.getReturnType() == Boolean.class || m.getReturnType() == Boolean.TYPE) && m.getName().startsWith(IS)) {
                        fieldName = this.uncapitalize(m.getName().substring(2));
                        getters.put(fieldName, m);
                        continue;
                    }
                    if (!m.getName().startsWith(GET) || GET_CLASS.equals(m.getName())) continue;
                    fieldName = this.uncapitalize(m.getName().replaceFirst(GET_IS, ""));
                    getters.put(fieldName, m);
                }
            }
            return getters;
        });
    }

    private String uncapitalize(String str) {
        int codepoint;
        int newCodePoint;
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        int firstCodepoint = str.codePointAt(0);
        if (firstCodepoint == (newCodePoint = Character.toLowerCase(firstCodepoint))) {
            return str;
        }
        int[] newCodePoints = new int[strLen];
        int outOffset = 0;
        newCodePoints[outOffset++] = newCodePoint;
        for (int inOffset = Character.charCount(firstCodepoint); inOffset < strLen; inOffset += Character.charCount(codepoint)) {
            codepoint = str.codePointAt(inOffset);
            newCodePoints[outOffset++] = codepoint;
        }
        return new String(newCodePoints, 0, outOffset);
    }
}

