/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.generator.javafile.template;

import cn.org.atool.fluent.mybatis.metadata.DbType;
import cn.org.atool.generator.database.config.impl.RelationConfig;
import cn.org.atool.generator.database.model.Naming;
import cn.org.atool.generator.database.model.TableField;
import cn.org.atool.generator.database.model.TableSetter;
import cn.org.atool.generator.javafile.template.AbstractTemplateFile;
import cn.org.atool.generator.util.ClassNames;
import cn.org.atool.generator.util.FluentMybatisKit;
import cn.org.atool.generator.util.GeneratorHelper;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class EntityFile
extends AbstractTemplateFile {
    public EntityFile(TableSetter table) {
        super(table);
        this.packageName = EntityFile.entityPackage(table);
        this.klassName = EntityFile.entityClass(table);
    }

    public static TypeName entityName(TableSetter table) {
        return ClassName.get((String)EntityFile.entityPackage(table), (String)EntityFile.entityClass(table), (String[])new String[0]);
    }

    public static String entityPackage(TableSetter table) {
        return table.gc().getBasePackage() + ".entity";
    }

    public static String entityClass(TableSetter table) {
        String entityPrefix = table.getEntityPrefix();
        if (entityPrefix.endsWith(table.getEntitySuffix())) {
            return entityPrefix;
        }
        return entityPrefix + table.getEntitySuffix();
    }

    @Override
    protected void build(TypeSpec.Builder spec) {
        spec.addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "{$S, $S}", new Object[]{"rawtypes", "unchecked"}).build());
        this.lombok(spec).addAnnotation(this.fluentMybatisAnnotation()).addJavadoc("$T: \u6570\u636e\u6620\u5c04\u5b9e\u4f53\u5b9a\u4e49\n\n", new Object[]{super.className()}).addJavadoc("$L", new Object[]{"@author Powered By Fluent Mybatis"});
        Set<String> exists = this.addSuperClass(spec);
        this.addSuperInterface(spec, this.table.getEntityInterfaces());
        spec.addField(this.f_serialVersionUID());
        for (TableField field : this.table.getFields()) {
            if (exists.contains(field.getName())) continue;
            FieldSpec.Builder fb = FieldSpec.builder((TypeName)field.getJavaType(), (String)field.getName(), (javax.lang.model.element.Modifier[])new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PRIVATE});
            if (field.isPrimary() && !"user".equals(this.table.getSeqName())) {
                fb.addAnnotation(this.getTableIdAnnotation(field));
            } else {
                fb.addAnnotation(this.getTableFieldAnnotation(field));
            }
            this.setFieldTypeAnnotation(fb, field);
            spec.addField(fb.build());
            if (this.table.gc().isLombok()) continue;
            String capital = Naming.capitalFirst(field.getName());
            spec.addMethod(this.m_getter(capital, field));
            spec.addMethod(this.m_setter(capital, field, this.table.gc().isSetterChain()));
        }
        spec.addMethod(this.m_entityClass());
        for (RelationConfig relation : this.table.getRelations()) {
            spec.addMethod(this.m_relation(relation));
        }
    }

    private void setFieldTypeAnnotation(FieldSpec.Builder spec, TableField field) {
        String column = field.getColumnName();
        if (Objects.equals(this.table.getLogicDeleted(), column)) {
            spec.addAnnotation(ClassNames.FM_LogicDelete);
        }
        if (Objects.equals(this.table.getVersionField(), column)) {
            spec.addAnnotation(ClassNames.FM_Version);
        }
        if (Objects.equals(this.table.getGmtCreate(), column)) {
            spec.addAnnotation(ClassNames.FM_GmtCreate);
        }
        if (Objects.equals(this.table.getGmtModified(), column)) {
            spec.addAnnotation(ClassNames.FM_GmtModified);
        }
    }

    private FieldSpec f_serialVersionUID() {
        return FieldSpec.builder(Long.TYPE, (String)"serialVersionUID", (javax.lang.model.element.Modifier[])ClassNames.PRIVATE_STATIC_FINAL).initializer(CodeBlock.of((String)"1L", (Object[])new Object[0])).build();
    }

    private Set<String> addSuperClass(TypeSpec.Builder spec) {
        Class superEntity = this.table.getSuperEntity();
        HashSet<String> fields = new HashSet<String>();
        if (superEntity != null) {
            if (FluentMybatisKit.hasEntityType(superEntity)) {
                spec.superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get((Class)superEntity), (TypeName[])new TypeName[]{super.className()}));
            } else {
                spec.superclass((Type)superEntity);
            }
            Class klass = superEntity;
            while (FluentMybatisKit.notBaseEntityClass(klass)) {
                fields.addAll(this.getFields(klass));
                klass = klass.getSuperclass();
            }
        } else if (this.table.gc().isRichEntity()) {
            spec.superclass((TypeName)ClassNames.FM_RichEntity);
        } else {
            spec.superclass((TypeName)ClassNames.FM_BaseEntity);
        }
        return fields;
    }

    private Set<String> getFields(Class superEntity) {
        HashSet<String> fields = new HashSet<String>();
        for (Field field : superEntity.getDeclaredFields()) {
            int mod = field.getModifiers();
            if (Modifier.isTransient(mod) || Modifier.isStatic(mod)) continue;
            fields.add(field.getName());
        }
        return fields;
    }

    private TypeSpec.Builder lombok(TypeSpec.Builder spec) {
        if (!this.table.gc().isLombok()) {
            return spec;
        }
        spec.addAnnotation(ClassNames.Lombok_Data);
        if (this.table.gc().isSetterChain()) {
            spec.addAnnotation(AnnotationSpec.builder((ClassName)ClassNames.Lombok_Accessors).addMember("chain", "true", new Object[0]).build());
        }
        spec.addAnnotation(AnnotationSpec.builder((ClassName)ClassNames.Lombok_EqualsAndHashCode).addMember("callSuper", "false", new Object[0]).build()).addAnnotation(ClassNames.Lombok_AllArgsConstructor).addAnnotation(ClassNames.Lombok_NoArgsConstructor);
        if (this.table.gc().isLombokBuilder()) {
            spec.addAnnotation(ClassNames.Lombok_Builder);
        }
        return spec;
    }

    private MethodSpec m_getter(String capital, TableField field) {
        return MethodSpec.methodBuilder((String)("get" + capital)).addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC}).returns(field.getJavaType()).addStatement("return this.$L", new Object[]{field.getName()}).build();
    }

    private MethodSpec m_setter(String capital, TableField field, boolean setterChain) {
        MethodSpec.Builder spec = MethodSpec.methodBuilder((String)("set" + capital)).addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC});
        if (setterChain) {
            spec.returns((TypeName)this.className());
        }
        spec.addParameter(field.getJavaType(), field.getName(), new javax.lang.model.element.Modifier[0]).addStatement("this.$L = $L", new Object[]{field.getName(), field.getName()});
        if (setterChain) {
            spec.addStatement("return this", new Object[0]);
        }
        return spec.build();
    }

    private MethodSpec m_entityClass() {
        return MethodSpec.methodBuilder((String)"entityClass").addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC, javax.lang.model.element.Modifier.FINAL}).addAnnotation(Override.class).returns(Class.class).addStatement("return $L.class", new Object[]{EntityFile.entityClass(this.table)}).build();
    }

    private MethodSpec m_relation(RelationConfig relation) {
        String methodName = relation.methodName();
        String entityName = EntityFile.entityClass(this.table);
        boolean isAbstract = relation.getRelationByFields().isEmpty() && relation.getRelationByColumns().isEmpty();
        MethodSpec.Builder spec = MethodSpec.methodBuilder((String)methodName).addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC}).addAnnotation(relation.refMethodAnnotation()).returns(relation.returnType()).addStatement("return super.invoke($S, $L)", new Object[]{methodName, relation.isCached()});
        if (isAbstract) {
            spec.addJavadoc("@see $L.IEntityRelation#$LOf$L($L)", new Object[]{this.table.gc().getBasePackage(), methodName, entityName, entityName});
        } else {
            spec.addJavadoc("@see $L.IEntityRelation#$LOf$L($T)", new Object[]{this.table.gc().getBasePackage(), methodName, entityName, List.class});
        }
        return spec.build();
    }

    private AnnotationSpec getTableFieldAnnotation(TableField field) {
        AnnotationSpec.Builder spec = AnnotationSpec.builder((ClassName)ClassNames.FM_TableField).addMember("value", "$S", new Object[]{field.getColumnName()});
        if (!GeneratorHelper.isBlank(field.getInsert())) {
            spec.addMember("insert", "$S", new Object[]{field.getInsert()});
        }
        if (!GeneratorHelper.isBlank(field.getUpdate())) {
            spec.addMember("update", "$S", new Object[]{field.getUpdate()});
        }
        if (field.getIsLarge() != null && !field.getIsLarge().booleanValue()) {
            spec.addMember("notLarge", "$L", new Object[]{Boolean.FALSE.toString()});
        }
        this.addHandlerAndComment(spec, field);
        return spec.build();
    }

    private AnnotationSpec getTableIdAnnotation(TableField field) {
        boolean before;
        AnnotationSpec.Builder spec = AnnotationSpec.builder((ClassName)ClassNames.FM_TableId).addMember("value", "$S", new Object[]{field.getColumnName()});
        String seqName = this.table.getSeqName();
        if (!this.isAuto(seqName, field.isPrimaryId())) {
            spec.addMember("auto", "$L", new Object[]{Boolean.FALSE.toString()});
        }
        if (!GeneratorHelper.isBlank(seqName) && !"auto".equals(seqName)) {
            spec.addMember("seqName", "$S", new Object[]{seqName});
        }
        if (before = this.table.selectKeyBefore()) {
            spec.addMember("before", "$L", new Object[]{true});
        }
        this.addHandlerAndComment(spec, field);
        return spec.build();
    }

    private void addHandlerAndComment(AnnotationSpec.Builder spec, TableField field) {
        String comment;
        if (field.getTypeHandler() != null) {
            spec.addMember("typeHandler", "$T.class", new Object[]{field.getTypeHandler()});
        }
        if (!GeneratorHelper.isBlank(comment = field.getComment())) {
            spec.addMember("desc", "$S", new Object[]{this.notNewLine(comment)});
        }
    }

    boolean isAuto(String seqName, boolean isPrimaryId) {
        return "auto".equals(seqName) || "".equals(seqName) && isPrimaryId;
    }

    private void addSuperInterface(TypeSpec.Builder builder, List<Class> interfaces) {
        if (interfaces == null || interfaces.size() == 0) {
            return;
        }
        for (Class _interface : interfaces) {
            if (FluentMybatisKit.hasEntityType(_interface)) {
                builder.addSuperinterface(this.parameterizedType(ClassName.get((Class)_interface), new TypeName[]{this.className()}));
                continue;
            }
            builder.addSuperinterface((Type)_interface);
        }
    }

    private AnnotationSpec fluentMybatisAnnotation() {
        AnnotationSpec.Builder builder = AnnotationSpec.builder((ClassName)ClassNames.FM_FluentMybatis);
        builder.addMember("table", "$S", new Object[]{this.table.getTableName()});
        if (!this.table.gc().getSchema().trim().isEmpty()) {
            builder.addMember("schema", "$S", new Object[]{this.table.gc().getSchema().trim()});
        }
        if (this.table.gc().isUseCached()) {
            builder.addMember("useCached", "true", new Object[0]);
        }
        if (!GeneratorHelper.isBlank(this.table.getMapperBeanPrefix())) {
            builder.addMember("mapperBeanPrefix", "$S", new Object[]{this.table.getMapperBeanPrefix()});
        }
        if (this.table.getDefaults() != null) {
            builder.addMember("defaults", "$T.class", new Object[]{this.table.getDefaults()});
        }
        if (this.table.getSuperMapper() != null) {
            builder.addMember("superMapper", "$T.class", new Object[]{this.table.getSuperMapper()});
        }
        if (!Objects.equals(this.table.getEntitySuffix(), "Entity")) {
            builder.addMember("suffix", "$S", new Object[]{this.table.getEntitySuffix()});
        }
        if (DbType.MYSQL != this.table.gc().getDbType()) {
            builder.addMember("dbType", "$T.$L", new Object[]{ClassNames.FM_FluentDbType, this.table.gc().getDbType().name()});
        }
        if (!this.table.isUseDao()) {
            builder.addMember("useDao", "false", new Object[0]);
        }
        if (!GeneratorHelper.isBlank(this.table.getComment())) {
            builder.addMember("desc", "$S", new Object[]{this.notNewLine(this.table.getComment())});
        }
        return builder.build();
    }

    private String notNewLine(String text) {
        if (text == null) {
            return "";
        }
        return text.replaceAll("[\\n\\r]+", ";").trim();
    }

    @Override
    protected boolean isInterface() {
        return false;
    }
}

