/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.generator.javafile.summary;

import cn.org.atool.generator.database.model.Naming;
import cn.org.atool.generator.database.model.TableSetter;
import cn.org.atool.generator.javafile.summary.AbstractSummaryFile;
import cn.org.atool.generator.javafile.template.DataMapFile;
import cn.org.atool.generator.javafile.template.TableMixFile;
import cn.org.atool.generator.util.ClassNames;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;

public class ATMFile
extends AbstractSummaryFile {
    public ATMFile(String basePackage, List<TableSetter> tables) {
        super(basePackage, tables);
        this.klassName = "ATM";
    }

    @Override
    protected void build(TypeSpec.Builder spec) {
        spec.addJavadoc("$L", new Object[]{"ATM: Application Table Manager\n\n"}).addJavadoc("$L", new Object[]{"@author Powered By Test4J"}).addAnnotation(super.suppressWarnings("unused", "rawtypes"));
        spec.addField(this.f_dataMap()).addField(this.f_table()).addField(this.f_mixes()).addType(this.type_Table()).addType(this.type_DataMap()).addType(this.type_Mixes()).addType(this.type_Script());
    }

    private FieldSpec f_dataMap() {
        return FieldSpec.builder((TypeName)TypeVariableName.get((String)"DataMap"), (String)"dataMap", (Modifier[])ClassNames.PUBLIC_STATIC_FINAL).initializer(CodeBlock.of((String)"new DataMap()", (Object[])new Object[0])).build();
    }

    private FieldSpec f_table() {
        return FieldSpec.builder((TypeName)TypeVariableName.get((String)"Table"), (String)"table", (Modifier[])ClassNames.PUBLIC_STATIC_FINAL).initializer(CodeBlock.of((String)"new Table()", (Object[])new Object[0])).build();
    }

    private FieldSpec f_mixes() {
        return FieldSpec.builder((TypeName)TypeVariableName.get((String)"Mixes"), (String)"mixes", (Modifier[])ClassNames.PUBLIC_STATIC_FINAL).initializer(CodeBlock.of((String)"new Mixes()", (Object[])new Object[0])).build();
    }

    private TypeSpec type_Script() {
        TypeSpec.Builder builder = this.getTypeBuilder("Script", false).addSuperinterface((TypeName)ClassNames.Test4J_IDataSourceScript).addJavadoc("\u5e94\u7528\u6570\u636e\u5e93\u521b\u5efa\u811a\u672c\u6784\u9020", new Object[0]);
        MethodSpec.Builder mb = MethodSpec.methodBuilder((String)"getTableKlass").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(this.parameterizedType(List.class, Class.class)).addCode("return list(\n", new Object[0]).addCode(this.tables.stream().map(t -> "\t" + t.getEntityPrefix() + "DataMap.class").collect(Collectors.joining(",\n")), new Object[0]).addCode("\n);", new Object[0]);
        builder.addMethod(mb.build());
        builder.addMethod(MethodSpec.methodBuilder((String)"getIndexList").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)TypeVariableName.get((String)"IndexList")).addStatement("return new IndexList()", new Object[0]).build());
        return builder.build();
    }

    private TypeSpec type_Mixes() {
        TypeSpec.Builder builder = this.getTypeBuilder("Mixes", false).addJavadoc("\u5e94\u7528\u8868\u6570\u636e\u64cd\u4f5c", new Object[0]);
        MethodSpec.Builder mb = MethodSpec.methodBuilder((String)"cleanAllTable").addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (TableSetter table : this.tables) {
            String mixName = Naming.lowerFirst(table.getEntityPrefix()) + "TableMix";
            builder.addField(FieldSpec.builder((TypeName)TableMixFile.mixClass(table), (String)mixName, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).initializer(CodeBlock.of((String)"$T.proxy($T.class)", (Object[])new Object[]{ClassNames.Test4J_MixProxy, TableMixFile.mixClass(table)})).build());
            mb.addStatement("this.$L.clean$LTable()", new Object[]{mixName, table.getEntityPrefix()});
        }
        builder.addMethod(mb.build());
        return builder.build();
    }

    private TypeSpec type_Table() {
        TypeSpec.Builder builder = this.getTypeBuilder("Table", false).addJavadoc("\u5e94\u7528\u8868\u540d", new Object[0]);
        for (TableSetter table : this.tables) {
            builder.addField(FieldSpec.builder(String.class, (String)Naming.lowerFirst(table.getEntityPrefix()), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).initializer(CodeBlock.of((String)"$S", (Object[])new Object[]{table.getTableName()})).build());
        }
        return builder.build();
    }

    private TypeSpec type_DataMap() {
        TypeSpec.Builder builder = this.getTypeBuilder("DataMap", false).addJavadoc("table or entity data\u6784\u9020\u5668", new Object[0]);
        for (TableSetter table : this.tables) {
            builder.addField(FieldSpec.builder((TypeName)TypeVariableName.get((String)(DataMapFile.dmClassName(table) + ".Factory")), (String)Naming.lowerFirst(table.getEntityPrefix()), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).initializer(CodeBlock.of((String)"new $T.Factory()", (Object[])new Object[]{DataMapFile.dmName(table)})).build());
        }
        return builder.build();
    }

    @Override
    protected boolean isInterface() {
        return true;
    }

    private TypeSpec.Builder getTypeBuilder(String className, boolean isInterface) {
        if (isInterface) {
            return TypeSpec.interfaceBuilder((String)className).addModifiers(ClassNames.PUBLIC_STATIC);
        }
        return TypeSpec.classBuilder((String)className).addModifiers(ClassNames.PUBLIC_STATIC);
    }
}

