/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.generator.database.model;

import cn.org.atool.fluent.mybatis.metadata.DbType;
import cn.org.atool.generator.database.config.impl.GlobalConfig;
import cn.org.atool.generator.database.config.impl.RelationConfig;
import cn.org.atool.generator.database.config.impl.TableConfigSet;
import cn.org.atool.generator.database.model.CustomizedColumn;
import cn.org.atool.generator.database.model.DateType;
import cn.org.atool.generator.database.model.FieldType;
import cn.org.atool.generator.database.model.Naming;
import cn.org.atool.generator.database.model.TableField;
import cn.org.atool.generator.util.FluentMybatisKit;
import cn.org.atool.generator.util.GeneratorHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.mybatis.generator.api.IntrospectedColumn;

public class TableSetter {
    private String tableName;
    private DateType dateType = DateType.ONLY_DATE;
    private String[] tablePrefix;
    private String matchedPrefix = "";
    private String entityPrefix;
    private String entitySuffix = "Entity";
    private List<RelationConfig> relations = new ArrayList<RelationConfig>();
    private String seqName;
    private boolean useDao;
    private Map<String, CustomizedColumn> columns = new HashMap<String, CustomizedColumn>();
    private String comment;
    private List<TableField> fields = new ArrayList<TableField>();
    private Map<String, TableField> fieldMap = new HashMap<String, TableField>();
    private String fieldNames;
    private final GlobalConfig globalConfig;
    private final TableConfigSet tableConfig;
    private final Set<String> importTypes = new HashSet<String>();
    private Map<FieldType, String> fileTypeName = new HashMap<FieldType, String>();
    private String gmtCreate;
    private String gmtModified;
    private String logicDeleted;
    private String versionField;
    private static final String NOW = "now()";
    private transient boolean haveId = false;
    private Class defaults;
    private Class superMapper;
    private Class superEntity;
    private List<Class> entityInterfaces = new ArrayList<Class>();
    private String mapperBeanPrefix = "";

    public TableSetter(String tableName, GlobalConfig globalConfig, TableConfigSet tableConfig) {
        this(tableName, null, globalConfig, tableConfig);
    }

    public TableSetter(String tableName, String entityPrefix, GlobalConfig globalConfig, TableConfigSet tableConfig) {
        this.tableName = tableName;
        this.entityPrefix = entityPrefix;
        this.globalConfig = globalConfig;
        this.tableConfig = tableConfig;
    }

    public TableSetter setTablePrefix(String ... tablePrefix) {
        if (!this.hasPrefix()) {
            this.tablePrefix = tablePrefix;
        }
        return this;
    }

    public TableSetter setGmtCreate(String gmtCreate) {
        if (GeneratorHelper.isBlank(gmtCreate) || !GeneratorHelper.isBlank(this.gmtCreate)) {
            return this;
        }
        this.gmtCreate = gmtCreate;
        this.setColumn(this.gmtCreate, (CustomizedColumn f) -> f.setInsert(NOW));
        return this;
    }

    public TableSetter setGmtModified(String gmtModified) {
        if (GeneratorHelper.isBlank(gmtModified) || !GeneratorHelper.isBlank(this.gmtModified)) {
            return this;
        }
        this.gmtModified = gmtModified;
        this.setColumn(this.gmtModified, (CustomizedColumn f) -> f.setInsert(NOW).setUpdate(NOW));
        return this;
    }

    public TableSetter setLogicDeleted(String logicDeleted) {
        if (GeneratorHelper.isBlank(logicDeleted) || !GeneratorHelper.isBlank(this.logicDeleted)) {
            return this;
        }
        this.logicDeleted = logicDeleted;
        this.setColumn(this.logicDeleted, (CustomizedColumn f) -> f.setJavaType(Boolean.class, new Class[0]).setInsert("0"));
        return this;
    }

    public TableSetter setVersionField(String versionField) {
        if (GeneratorHelper.isBlank(versionField) || !GeneratorHelper.isBlank(this.versionField)) {
            return this;
        }
        this.versionField = versionField;
        DbType dbType = DbType.valueOf((String)this.globalConfig.getDbType().name());
        this.setColumn(this.versionField, (CustomizedColumn f) -> f.setJavaType(Long.class, new Class[0]).setInsert("0").setUpdate(dbType.wrap(this.versionField) + " + 1"));
        return this;
    }

    public TableSetter setColumn(String columnName, String propertyName) {
        this.getDefinedColumn(columnName).setFieldName(propertyName);
        return this;
    }

    public TableSetter setColumn(String column, Consumer<CustomizedColumn> consumer) {
        CustomizedColumn customizedColumn = this.getDefinedColumn(column);
        consumer.accept(customizedColumn);
        return this;
    }

    private CustomizedColumn getDefinedColumn(String column) {
        if (GeneratorHelper.isBlank(column)) {
            throw new RuntimeException("The column can't be null.");
        }
        if (!this.columns.containsKey(column)) {
            this.columns.put(column, new CustomizedColumn(column));
        }
        return this.columns.get(column);
    }

    public TableSetter setExcludes(String ... columnNames) {
        for (String column : columnNames) {
            this.columns.put(column, new CustomizedColumn(column).setExclude());
        }
        return this;
    }

    private boolean isExclude(String field) {
        CustomizedColumn column = this.columns.get(field);
        return column != null && column.isExclude();
    }

    public void initEntityPrefix() {
        if (!GeneratorHelper.isBlank(this.entityPrefix)) {
            return;
        }
        String noPrefix = this.getNoPrefixTableName();
        if (this.globalConfig.getTableNaming() == Naming.underline_to_camel) {
            noPrefix = Naming.underlineToCamel(noPrefix);
        }
        this.entityPrefix = Naming.capitalFirst(noPrefix);
    }

    public String getNoPrefixTableName() {
        if (this.hasPrefix()) {
            String noPrefix = Naming.removePrefix(this.tableName, this.tablePrefix);
            this.matchedPrefix = this.tableName.substring(0, this.tableName.length() - noPrefix.length());
            return noPrefix;
        }
        return this.tableName;
    }

    private boolean hasPrefix() {
        return this.tablePrefix != null && this.tablePrefix.length > 0;
    }

    public List<TableField> initTableFields(String tableName, List<IntrospectedColumn> columns, boolean isPrimary) {
        for (IntrospectedColumn column : columns) {
            String columnName = column.getActualColumnName();
            TableField field = this.initTableField(tableName, column, isPrimary);
            if (field == null || this.isExclude(columnName)) continue;
            if (!field.isPrimary()) {
                field.setCategory(this.getFieldCategory(columnName));
            }
            this.fields.add(field);
            this.fieldMap.put(columnName, field);
        }
        if (this.globalConfig.isAlphabetOrder()) {
            Collections.sort(this.fields);
        }
        this.fieldNames = this.fields.stream().map(TableField::getColumnName).collect(Collectors.joining(", "));
        return this.fields;
    }

    private FieldType getFieldCategory(String fieldName) {
        if (fieldName.equalsIgnoreCase(this.gmtCreate)) {
            return FieldType.GmtCreate;
        }
        if (fieldName.equalsIgnoreCase(this.gmtModified)) {
            return FieldType.GmtModified;
        }
        if (fieldName.equalsIgnoreCase(this.logicDeleted)) {
            return FieldType.IsDeleted;
        }
        return FieldType.Common;
    }

    private TableField initTableField(String tableName, IntrospectedColumn column, boolean isPrimary) {
        String columnName = column.getActualColumnName();
        if (this.isExclude(columnName)) {
            return null;
        }
        TableField field = new TableField(this.globalConfig, this.tableName, columnName, this.columns.get(columnName));
        boolean autoIncrease = column.isAutoIncrement();
        if (isPrimary && !this.haveId) {
            field.setCategory(autoIncrease ? FieldType.PrimaryId : FieldType.PrimaryKey);
            this.haveId = true;
        }
        field.initNamingAndType(tableName, column);
        return field;
    }

    public TableSetter setDefaults(Class defaults) {
        this.defaults = defaults;
        return this;
    }

    public TableSetter setSuperMapper(Class superMapper) {
        this.superMapper = superMapper;
        return this;
    }

    public TableSetter addEntityInterface(Class interfaceType) {
        if (!FluentMybatisKit.isIEntity(interfaceType)) {
            throw new RuntimeException("The class[" + interfaceType + "] must inherit interface IEntity.");
        }
        if (interfaceType.isInterface()) {
            this.entityInterfaces.add(interfaceType);
        } else if (this.superEntity == null) {
            if (!FluentMybatisKit.isBaseEntity(interfaceType)) {
                throw new RuntimeException("The class[" + interfaceType + "] must inherit class BaseEntity.");
            }
            this.superEntity = interfaceType;
        } else {
            throw new RuntimeException("The Entity can only has one superclass, but more than one were found:" + this.superEntity.getName() + " and " + interfaceType.getName());
        }
        return this;
    }

    public TableSetter setMapperPrefix(String mapperBeanPrefix) {
        this.mapperBeanPrefix = mapperBeanPrefix;
        return this;
    }

    public String getField(String column) {
        if (!this.fieldMap.containsKey(column)) {
            throw new RuntimeException(String.format("the field[%s] of table[%s] not found.", column, this.tableName));
        }
        try {
            return this.fieldMap.get(column).getName();
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("getField[table=%s, column=%s] error:%s", this.tableName, column, e.getMessage()), e);
        }
    }

    public boolean selectKeyBefore() {
        int before = this.globalConfig.getSelectKeyBefore();
        if (before == 0) {
            return this.globalConfig.getDbType().feature.isBefore();
        }
        return before > 0;
    }

    public GlobalConfig gc() {
        return this.globalConfig;
    }

    public String getTableName() {
        return this.tableName;
    }

    public DateType getDateType() {
        return this.dateType;
    }

    public String[] getTablePrefix() {
        return this.tablePrefix;
    }

    public String getMatchedPrefix() {
        return this.matchedPrefix;
    }

    public String getEntityPrefix() {
        return this.entityPrefix;
    }

    public String getEntitySuffix() {
        return this.entitySuffix;
    }

    public List<RelationConfig> getRelations() {
        return this.relations;
    }

    public String getSeqName() {
        return this.seqName;
    }

    public boolean isUseDao() {
        return this.useDao;
    }

    public Map<String, CustomizedColumn> getColumns() {
        return this.columns;
    }

    public String getComment() {
        return this.comment;
    }

    public List<TableField> getFields() {
        return this.fields;
    }

    public Map<String, TableField> getFieldMap() {
        return this.fieldMap;
    }

    public String getFieldNames() {
        return this.fieldNames;
    }

    public TableConfigSet getTableConfig() {
        return this.tableConfig;
    }

    public Set<String> getImportTypes() {
        return this.importTypes;
    }

    public Map<FieldType, String> getFileTypeName() {
        return this.fileTypeName;
    }

    public String getGmtCreate() {
        return this.gmtCreate;
    }

    public String getGmtModified() {
        return this.gmtModified;
    }

    public String getLogicDeleted() {
        return this.logicDeleted;
    }

    public String getVersionField() {
        return this.versionField;
    }

    public Class getDefaults() {
        return this.defaults;
    }

    public Class getSuperMapper() {
        return this.superMapper;
    }

    public Class getSuperEntity() {
        return this.superEntity;
    }

    public List<Class> getEntityInterfaces() {
        return this.entityInterfaces;
    }

    public String getMapperBeanPrefix() {
        return this.mapperBeanPrefix;
    }

    public TableSetter setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public TableSetter setDateType(DateType dateType) {
        this.dateType = dateType;
        return this;
    }

    public TableSetter setEntityPrefix(String entityPrefix) {
        this.entityPrefix = entityPrefix;
        return this;
    }

    public TableSetter setEntitySuffix(String entitySuffix) {
        this.entitySuffix = entitySuffix;
        return this;
    }

    public TableSetter setSeqName(String seqName) {
        this.seqName = seqName;
        return this;
    }

    public TableSetter setUseDao(boolean useDao) {
        this.useDao = useDao;
        return this;
    }

    public TableSetter setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public TableSetter setMapperBeanPrefix(String mapperBeanPrefix) {
        this.mapperBeanPrefix = mapperBeanPrefix;
        return this;
    }
}

