/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.generator.database.model;

import cn.org.atool.generator.database.config.impl.ColumnConfig;
import cn.org.atool.generator.database.config.impl.GlobalConfig;
import cn.org.atool.generator.database.model.CustomizedColumn;
import cn.org.atool.generator.database.model.FieldType;
import cn.org.atool.generator.database.model.Naming;
import cn.org.atool.generator.util.ClassNames;
import cn.org.atool.generator.util.GeneratorHelper;
import cn.org.atool.generator.util.SchemaKits;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.util.Objects;
import java.util.Optional;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.UnknownTypeHandler;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;

public class TableField
implements Comparable<TableField> {
    private final String tableName;
    private final GlobalConfig globalConfig;
    private FieldType category = FieldType.Common;
    private final String columnName;
    private String name;
    private TypeName javaType;
    private Class<? extends TypeHandler> typeHandler;
    private String insert;
    private String update;
    private Boolean isLarge;
    private String capitalName;
    private String jdbcType;
    private boolean notNull = false;
    private String defaults = null;
    private String comment;

    public TableField(GlobalConfig globalConfig, String tableName, String columnName, CustomizedColumn customized) {
        this.globalConfig = globalConfig;
        this.tableName = tableName;
        this.columnName = columnName;
        ColumnConfig config = ColumnConfig.get(tableName, columnName);
        if (config != null) {
            this.initByConfig(config);
        }
        if (customized == null && globalConfig.getColumnFilter() != null) {
            customized = globalConfig.getColumnFilter().filter(tableName, columnName);
        }
        this.customizedField(customized);
    }

    private void customizedField(CustomizedColumn customized) {
        if (customized == null) {
            return;
        }
        if (!GeneratorHelper.isBlank(customized.getFieldName())) {
            this.name = customized.getFieldName();
        }
        if (customized.getJavaType() != null) {
            this.setJavaType(customized.getJavaType());
        }
        if (customized.getTypeHandler() != null && !Objects.equals(UnknownTypeHandler.class, customized.getTypeHandler())) {
            this.typeHandler = customized.getTypeHandler();
        }
        if (!customized.isNotLarge()) {
            this.isLarge = false;
        }
        if (!GeneratorHelper.isBlank(customized.getInsert())) {
            this.insert = customized.getInsert();
        }
        if (!GeneratorHelper.isBlank(customized.getUpdate())) {
            this.update = customized.getUpdate();
        }
    }

    private void initByConfig(ColumnConfig config) {
        this.name = config.getField();
        this.insert = config.getInsert();
        this.update = config.getUpdate();
        this.isLarge = config.isLarge();
        this.javaType = config.getJavaType();
        this.jdbcType = Optional.ofNullable(config.getJdbcType()).map(Enum::name).orElse(null);
        this.typeHandler = config.getTypeHandler();
        this.category = config.getCategory();
    }

    public void initNamingAndType(String tableName, IntrospectedColumn column) {
        this.jdbcType = column.getActualTypeName();
        if (SchemaKits.NEED_LENGTH_TYPES.contains(this.jdbcType.toUpperCase())) {
            this.jdbcType = String.format("%s(%d)", this.jdbcType, column.getLength());
        }
        if (SchemaKits.NEED_SCALE_TYPES.contains(this.jdbcType.toLowerCase())) {
            this.jdbcType = String.format("%s(%d, %d)", this.jdbcType, column.getLength(), column.getScale());
        }
        this.initFieldNameIfNeed();
        String capitalName = Naming.capitalFirst(this.removeIsIfNeed(this.name, this.globalConfig));
        this.initJavaTypeIfNeed(column);
        this.notNull = !column.isNullable();
        this.defaults = column.getDefaultValue();
        if (!GeneratorHelper.isBlank(this.defaults) && this.isStringType()) {
            this.defaults = "'" + this.defaults + "'";
        }
        this.comment = column.getRemarks();
        if (this.comment == null) {
            this.comment = "";
        }
    }

    private boolean isStringType() {
        return Objects.equals(ClassNames.CN_String, this.javaType);
    }

    private void initJavaTypeIfNeed(IntrospectedColumn column) {
        if (this.javaType != null) {
            return;
        }
        this.javaType = this.getJavaType(column);
    }

    private ClassName getJavaType(IntrospectedColumn column) {
        FullyQualifiedJavaType javaType = column.getFullyQualifiedJavaType();
        try {
            if (Objects.equals(javaType.getFullyQualifiedName(), Byte.class.getName())) {
                return ClassNames.CN_Integer;
            }
            return ClassName.get((String)javaType.getPackageName(), (String)javaType.getShortNameWithoutTypeArguments(), (String[])new String[0]);
        }
        catch (Exception e) {
            String err = String.format("getJavaType[%s] of column[%s/%s] error: %s", javaType.getFullyQualifiedName(), this.columnName, this.tableName, e.getMessage());
            throw new RuntimeException(err, e);
        }
    }

    private void initFieldNameIfNeed() {
        if (!GeneratorHelper.isBlank(this.name)) {
            return;
        }
        Naming naming = this.globalConfig.getColumnNaming();
        this.name = naming == Naming.underline_to_camel ? Naming.underlineToCamel(this.columnName) : this.columnName;
    }

    private String removeIsIfNeed(String input, GlobalConfig globalConfig) {
        if (globalConfig.needRemoveIsPrefix(input, this.getJavaType())) {
            return input.substring(2);
        }
        return input;
    }

    public boolean isPrimary() {
        return this.category == FieldType.PrimaryKey || this.category == FieldType.PrimaryId;
    }

    public boolean isPrimaryId() {
        return this.category == FieldType.PrimaryId;
    }

    public boolean isGmt() {
        return this.category == FieldType.GmtCreate || this.category == FieldType.GmtModified;
    }

    public boolean isDeleted() {
        return this.category == FieldType.IsDeleted;
    }

    @Override
    public int compareTo(TableField field) {
        if (field == null) {
            return 1;
        }
        int order = this.category.compareTo(field.category);
        if (order == 0) {
            order = this.name.compareTo(field.name);
        }
        return order;
    }

    public String getTableName() {
        return this.tableName;
    }

    public FieldType getCategory() {
        return this.category;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getName() {
        return this.name;
    }

    public TypeName getJavaType() {
        return this.javaType;
    }

    public Class<? extends TypeHandler> getTypeHandler() {
        return this.typeHandler;
    }

    public String getInsert() {
        return this.insert;
    }

    public String getUpdate() {
        return this.update;
    }

    public Boolean getIsLarge() {
        return this.isLarge;
    }

    public String getCapitalName() {
        return this.capitalName;
    }

    public String getJdbcType() {
        return this.jdbcType;
    }

    public boolean isNotNull() {
        return this.notNull;
    }

    public String getDefaults() {
        return this.defaults;
    }

    public String getComment() {
        return this.comment;
    }

    public TableField setCategory(FieldType category) {
        this.category = category;
        return this;
    }

    public TableField setName(String name) {
        this.name = name;
        return this;
    }

    public TableField setJavaType(TypeName javaType) {
        this.javaType = javaType;
        return this;
    }

    public TableField setTypeHandler(Class<? extends TypeHandler> typeHandler) {
        this.typeHandler = typeHandler;
        return this;
    }

    public TableField setInsert(String insert) {
        this.insert = insert;
        return this;
    }

    public TableField setUpdate(String update) {
        this.update = update;
        return this;
    }

    public TableField setIsLarge(Boolean isLarge) {
        this.isLarge = isLarge;
        return this;
    }
}

