/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.generator.database.config.impl;

import cn.org.atool.generator.annotation.Relation;
import cn.org.atool.generator.database.IRelationConfig;
import cn.org.atool.generator.database.config.impl.TableConfigSet;
import cn.org.atool.generator.database.model.Naming;
import cn.org.atool.generator.database.model.TableSetter;
import cn.org.atool.generator.util.ClassNames;
import cn.org.atool.generator.util.GeneratorHelper;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RelationConfig
implements IRelationConfig {
    private String method;
    private String sourceTable;
    private String sourcePackage;
    private String sourceEntity;
    private String targetTable;
    private String targetNoSuffix;
    private String targetPackage;
    private String targetEntity;
    private boolean isMany;
    private boolean cached;
    private final Map<String, String> relationByColumns = new HashMap<String, String>();
    private final Map<String, String> relationByFields = new HashMap<String, String>();

    public RelationConfig(TableConfigSet tableConfigSet, String source, String target) {
        this.sourceTable = source;
        this.targetTable = target;
        tableConfigSet.getTables().get(source).getRelations().add(this);
    }

    @Override
    public IRelationConfig table(String targetTable) {
        this.targetTable = targetTable;
        return this;
    }

    @Override
    public IRelationConfig setRelation(Map<String, String> relation, boolean reversed) {
        for (Map.Entry<String, String> entry : relation.entrySet()) {
            if (reversed) {
                this.relationByColumns.put(entry.getValue(), entry.getKey());
                continue;
            }
            this.relationByColumns.put(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public void properties(TableSetter source, TableSetter target) {
        for (Map.Entry<String, String> pair : this.relationByColumns.entrySet()) {
            String sourceField = source.getField(pair.getKey());
            String targetField = target.getField(pair.getValue());
            this.relationByFields.put(targetField, sourceField);
        }
    }

    private ClassName targetEntityClass() {
        return ClassName.get((String)this.targetPackage, (String)this.targetEntity, (String[])new String[0]);
    }

    public TypeName returnType() {
        if (this.isMany) {
            return ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{this.targetEntityClass()});
        }
        return this.targetEntityClass();
    }

    public String methodName() {
        if (!GeneratorHelper.isBlank(this.method)) {
            return this.method;
        }
        if (this.isMany) {
            return "find" + Naming.capitalFirst(this.targetNoSuffix) + "List";
        }
        return "find" + Naming.capitalFirst(this.targetNoSuffix);
    }

    public AnnotationSpec refMethodAnnotation() {
        AnnotationSpec.Builder spec = AnnotationSpec.builder((ClassName)ClassNames.FM_RefMethod);
        if (!this.relationByFields.isEmpty()) {
            String mapping = this.relationByFields.entrySet().stream().map(e -> (String)e.getKey() + " = " + (String)e.getValue()).collect(Collectors.joining(" && "));
            spec.addMember("value", "$S", new Object[]{mapping});
        }
        return spec.build();
    }

    public static Map<String, String> parseRelations(Relation relation) {
        String[] pairs;
        String values = relation.where();
        HashMap<String, String> relations = new HashMap<String, String>();
        if (GeneratorHelper.isBlank(values)) {
            return relations;
        }
        for (String pair : pairs = values.split("&")) {
            if (GeneratorHelper.isBlank(pair)) continue;
            if (!RelationConfig.isEquation(pair)) {
                throw new RuntimeException("the format of relation must be 'column_of_table1=column_of_table2', actual:" + pair);
            }
            String[] items = pair.split("=");
            relations.put(items[0].trim(), items[1].trim());
        }
        return relations;
    }

    public static boolean isEquation(String expression) {
        if (GeneratorHelper.isBlank(expression)) {
            return false;
        }
        return expression.trim().matches("[a-zA-Z0-9_]+\\s*=\\s*[a-zA-Z0-9_]+");
    }

    public String getMethod() {
        return this.method;
    }

    public String getSourceTable() {
        return this.sourceTable;
    }

    public String getSourcePackage() {
        return this.sourcePackage;
    }

    public String getSourceEntity() {
        return this.sourceEntity;
    }

    public String getTargetTable() {
        return this.targetTable;
    }

    public String getTargetNoSuffix() {
        return this.targetNoSuffix;
    }

    public String getTargetPackage() {
        return this.targetPackage;
    }

    public String getTargetEntity() {
        return this.targetEntity;
    }

    public boolean isMany() {
        return this.isMany;
    }

    public boolean isCached() {
        return this.cached;
    }

    public Map<String, String> getRelationByColumns() {
        return this.relationByColumns;
    }

    public Map<String, String> getRelationByFields() {
        return this.relationByFields;
    }

    public RelationConfig setMethod(String method) {
        this.method = method;
        return this;
    }

    public RelationConfig setSourceTable(String sourceTable) {
        this.sourceTable = sourceTable;
        return this;
    }

    public RelationConfig setSourcePackage(String sourcePackage) {
        this.sourcePackage = sourcePackage;
        return this;
    }

    public RelationConfig setSourceEntity(String sourceEntity) {
        this.sourceEntity = sourceEntity;
        return this;
    }

    public RelationConfig setTargetTable(String targetTable) {
        this.targetTable = targetTable;
        return this;
    }

    public RelationConfig setTargetNoSuffix(String targetNoSuffix) {
        this.targetNoSuffix = targetNoSuffix;
        return this;
    }

    public RelationConfig setTargetPackage(String targetPackage) {
        this.targetPackage = targetPackage;
        return this;
    }

    public RelationConfig setTargetEntity(String targetEntity) {
        this.targetEntity = targetEntity;
        return this;
    }

    @Override
    public RelationConfig setMany(boolean isMany) {
        this.isMany = isMany;
        return this;
    }

    public RelationConfig setCached(boolean cached) {
        this.cached = cached;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RelationConfig)) {
            return false;
        }
        RelationConfig other = (RelationConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isMany() != other.isMany()) {
            return false;
        }
        if (this.isCached() != other.isCached()) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$sourceTable = this.getSourceTable();
        String other$sourceTable = other.getSourceTable();
        if (this$sourceTable == null ? other$sourceTable != null : !this$sourceTable.equals(other$sourceTable)) {
            return false;
        }
        String this$sourcePackage = this.getSourcePackage();
        String other$sourcePackage = other.getSourcePackage();
        if (this$sourcePackage == null ? other$sourcePackage != null : !this$sourcePackage.equals(other$sourcePackage)) {
            return false;
        }
        String this$sourceEntity = this.getSourceEntity();
        String other$sourceEntity = other.getSourceEntity();
        if (this$sourceEntity == null ? other$sourceEntity != null : !this$sourceEntity.equals(other$sourceEntity)) {
            return false;
        }
        String this$targetTable = this.getTargetTable();
        String other$targetTable = other.getTargetTable();
        if (this$targetTable == null ? other$targetTable != null : !this$targetTable.equals(other$targetTable)) {
            return false;
        }
        String this$targetNoSuffix = this.getTargetNoSuffix();
        String other$targetNoSuffix = other.getTargetNoSuffix();
        if (this$targetNoSuffix == null ? other$targetNoSuffix != null : !this$targetNoSuffix.equals(other$targetNoSuffix)) {
            return false;
        }
        String this$targetPackage = this.getTargetPackage();
        String other$targetPackage = other.getTargetPackage();
        if (this$targetPackage == null ? other$targetPackage != null : !this$targetPackage.equals(other$targetPackage)) {
            return false;
        }
        String this$targetEntity = this.getTargetEntity();
        String other$targetEntity = other.getTargetEntity();
        if (this$targetEntity == null ? other$targetEntity != null : !this$targetEntity.equals(other$targetEntity)) {
            return false;
        }
        Map<String, String> this$relationByColumns = this.getRelationByColumns();
        Map<String, String> other$relationByColumns = other.getRelationByColumns();
        if (this$relationByColumns == null ? other$relationByColumns != null : !((Object)this$relationByColumns).equals(other$relationByColumns)) {
            return false;
        }
        Map<String, String> this$relationByFields = this.getRelationByFields();
        Map<String, String> other$relationByFields = other.getRelationByFields();
        return !(this$relationByFields == null ? other$relationByFields != null : !((Object)this$relationByFields).equals(other$relationByFields));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RelationConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isMany() ? 79 : 97);
        result = result * 59 + (this.isCached() ? 79 : 97);
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $sourceTable = this.getSourceTable();
        result = result * 59 + ($sourceTable == null ? 43 : $sourceTable.hashCode());
        String $sourcePackage = this.getSourcePackage();
        result = result * 59 + ($sourcePackage == null ? 43 : $sourcePackage.hashCode());
        String $sourceEntity = this.getSourceEntity();
        result = result * 59 + ($sourceEntity == null ? 43 : $sourceEntity.hashCode());
        String $targetTable = this.getTargetTable();
        result = result * 59 + ($targetTable == null ? 43 : $targetTable.hashCode());
        String $targetNoSuffix = this.getTargetNoSuffix();
        result = result * 59 + ($targetNoSuffix == null ? 43 : $targetNoSuffix.hashCode());
        String $targetPackage = this.getTargetPackage();
        result = result * 59 + ($targetPackage == null ? 43 : $targetPackage.hashCode());
        String $targetEntity = this.getTargetEntity();
        result = result * 59 + ($targetEntity == null ? 43 : $targetEntity.hashCode());
        Map<String, String> $relationByColumns = this.getRelationByColumns();
        result = result * 59 + ($relationByColumns == null ? 43 : ((Object)$relationByColumns).hashCode());
        Map<String, String> $relationByFields = this.getRelationByFields();
        result = result * 59 + ($relationByFields == null ? 43 : ((Object)$relationByFields).hashCode());
        return result;
    }

    public String toString() {
        return "RelationConfig(method=" + this.getMethod() + ", sourceTable=" + this.getSourceTable() + ", sourcePackage=" + this.getSourcePackage() + ", sourceEntity=" + this.getSourceEntity() + ", targetTable=" + this.getTargetTable() + ", targetNoSuffix=" + this.getTargetNoSuffix() + ", targetPackage=" + this.getTargetPackage() + ", targetEntity=" + this.getTargetEntity() + ", isMany=" + this.isMany() + ", cached=" + this.isCached() + ", relationByColumns=" + this.getRelationByColumns() + ", relationByFields=" + this.getRelationByFields() + ")";
    }
}

