/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.generator;

import cn.org.atool.generator.database.config.impl.ColumnConfig;
import cn.org.atool.generator.database.config.impl.ColumnFilter;
import cn.org.atool.generator.javafile.AnnotationGenerator;
import cn.org.atool.generator.javafile.TemplateGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import javax.sql.DataSource;

public class FileGenerator {
    private final Properties properties = new Properties();
    private DataSource dataSource;
    private final List<Class> classes = new ArrayList<Class>();
    private ColumnFilter filter;

    public FileGenerator forceBigDecimals() {
        this.properties.put("forceBigDecimals", "true");
        return this;
    }

    public FileGenerator useJSR310Types() {
        this.properties.put("useJSR310Types", "true");
        return this;
    }

    public FileGenerator dataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public FileGenerator column(String table, String column, Consumer<ColumnConfig> config) {
        config.accept(ColumnConfig.set(table == null ? "*" : table, column));
        return this;
    }

    public FileGenerator column(ColumnFilter filter) {
        this.filter = filter;
        return this;
    }

    public FileGenerator with(Class ... classes) {
        this.classes.addAll(Arrays.asList(classes));
        return this;
    }

    public void generate() {
        for (Class clazz : this.classes) {
            AnnotationGenerator.generate(this, clazz);
        }
        if (TemplateGenerator.withTest) {
            TemplateGenerator.generateSummary();
        }
    }

    public static ColumnConfig setColumn(String table, String column, String field) {
        return ColumnConfig.set(table, column, field);
    }

    public static void build(DataSource dataSource, Class ... classes) {
        FileGenerator.build(dataSource, null, classes);
    }

    public static void build(Class ... classes) {
        FileGenerator.build(null, null, classes);
    }

    public static void build(DataSource dataSource, Properties properties, Class ... classes) {
        FileGenerator generator = new FileGenerator();
        generator.dataSource = dataSource;
        if (properties != null && properties.size() > 0) {
            generator.properties.putAll((Map<?, ?>)properties);
        }
        generator.classes.addAll(Arrays.asList(classes));
        generator.generate();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public List<Class> getClasses() {
        return this.classes;
    }

    public ColumnFilter getFilter() {
        return this.filter;
    }
}

