/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.utility;

import cn.org.atool.fluent.common.kits.KeyMap;
import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.entity.AMapping;
import cn.org.atool.fluent.mybatis.base.entity.IEntityKit;
import cn.org.atool.fluent.mybatis.base.entity.IMapping;
import cn.org.atool.fluent.mybatis.base.mapper.IEntityMapper;
import cn.org.atool.fluent.mybatis.base.mapper.IRichMapper;
import cn.org.atool.fluent.mybatis.base.mapper.IWrapperMapper;
import cn.org.atool.fluent.mybatis.exception.FluentMybatisException;
import cn.org.atool.fluent.mybatis.functions.IGetter;
import cn.org.atool.fluent.mybatis.functions.RefFinder;
import cn.org.atool.fluent.mybatis.functions.TableDynamic;
import cn.org.atool.fluent.mybatis.mapper.PrinterMapper;
import cn.org.atool.fluent.mybatis.metadata.DbType;
import cn.org.atool.fluent.mybatis.segment.BaseSegment;
import cn.org.atool.fluent.mybatis.typehandler.ConvertorKit;
import cn.org.atool.fluent.mybatis.typehandler.IConvertor;
import cn.org.atool.fluent.mybatis.utility.LambdaUtil;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class RefKit {
    public static final KeyMap<IGetter> relations = new KeyMap();
    public static final KeyMap<AMapping> ENTITY_MAPPING = new KeyMap();
    public static final KeyMap<AMapping> TABLE_MAPPING = new KeyMap();
    public static final KeyMap<IEntityMapper> ENTITY_MAPPER = new KeyMap();
    public static final KeyMap<AMapping> MAPPER_MAPPING = new KeyMap();

    public static AMapping byEntity(String entityClass) {
        if (ENTITY_MAPPING.containsKey(entityClass)) {
            return (AMapping)ENTITY_MAPPING.get(entityClass);
        }
        throw new RuntimeException("the class[" + entityClass + "] is not a @FluentMybatis Entity or it's Mapper not defined as bean.");
    }

    public static AMapping byTable(String table) {
        if (TABLE_MAPPING.containsKey(table)) {
            return (AMapping)TABLE_MAPPING.get(table);
        }
        throw new RuntimeException("the entity of table[" + table + "] is not a @FluentMybatis Entity or it's Mapper not defined as bean.");
    }

    public static AMapping byEntity(Class clazz) {
        return RefKit.byEntity(clazz.getName());
    }

    public static IEntityKit entityKit(Class clazz) {
        return RefKit.byEntity(clazz.getName());
    }

    public static AMapping byMapper(String mapperClass) {
        if (MAPPER_MAPPING.containsKey(mapperClass)) {
            return (AMapping)MAPPER_MAPPING.get(mapperClass);
        }
        throw RefKit.notFluentMybatisMapper(mapperClass);
    }

    public static IMapping byMapper(Class clazz) {
        return RefKit.byMapper(clazz.getName());
    }

    public static <M extends IEntityMapper> M mapperByEntity(Class entityClass) {
        return RefKit.mapperByEntity(entityClass.getName());
    }

    public static <M extends IEntityMapper> M mapperByEntity(String entityClass) {
        if (ENTITY_MAPPER.containsKey(entityClass)) {
            return (M)((IEntityMapper)ENTITY_MAPPER.get(entityClass));
        }
        throw RefKit.notFluentMybatisEntity(entityClass);
    }

    public static <E extends IEntity> String columnOfField(Class<E> eClass, String field) {
        AMapping mapping = RefKit.byEntity(eClass);
        if (mapping == null) {
            throw RefKit.notFluentMybatisEntity(eClass);
        }
        return mapping.columnOfField(field);
    }

    public static <E extends IEntity> String primaryId(Class<E> eClass) {
        AMapping mapping = RefKit.byEntity(eClass);
        if (mapping == null) {
            throw RefKit.notFluentMybatisEntity(eClass);
        }
        return mapping.primaryId(false);
    }

    public static Set<String> allEntityClass() {
        return ENTITY_MAPPER.keySet();
    }

    public static void dbType(DbType dbType, Class<? extends IEntity> ... eClasses) {
        Set<String> list = RefKit.getEntityClass(eClasses);
        for (String klass : list) {
            RefKit.byEntity(klass).db(dbType);
        }
    }

    public static void tableSupplier(TableDynamic tableSupplier, Class<? extends IEntity> ... eClasses) {
        Set<String> list = RefKit.getEntityClass(eClasses);
        for (String klass : list) {
            RefKit.byEntity(klass).setTableSupplier(tableSupplier);
        }
    }

    public static void register(Type type, IConvertor convertor) {
        ConvertorKit.register(type, convertor);
    }

    public static void register(String typeName, IConvertor convertor) {
        ConvertorKit.register(typeName, convertor);
    }

    public static <T> T invoke(Class eClass, String methodName, Object[] args) {
        IEntity entity = (IEntity)args[0];
        switch (methodName) {
            case "save": {
                return RefKit.save(eClass, entity);
            }
            case "updateById": {
                return RefKit.updateById(eClass, entity);
            }
            case "findById": {
                return RefKit.findById(eClass, entity);
            }
            case "deleteById": {
                return RefKit.deleteById(eClass, entity);
            }
            case "logicDeleteById": {
                return RefKit.logicDeleteById(eClass, entity);
            }
            case "listByNotNull": {
                return RefKit.listByNotNull(eClass, entity);
            }
            case "firstByNotNull": {
                return RefKit.firstByNotNull(eClass, entity);
            }
        }
        return RefKit.invokeRefMethod(eClass, methodName, entity);
    }

    public static <T> T invokeRefMethod(Class eClass, String methodName, Object eOrList) {
        String methodOfEntity = MybatisUtil.methodNameOfEntity(methodName, eClass);
        IGetter finder = (IGetter)relations.get(methodOfEntity);
        if (finder == null) {
            String err = "the method[" + methodName + "] of IEntityRelation not found or IEntityRelation's implement not defined as spring bean.";
            throw new RuntimeException(err);
        }
        if (finder instanceof RefFinder) {
            ((RefFinder)finder).relation(eOrList);
            return null;
        }
        return (T)finder.get(eOrList);
    }

    private static <T> T listByNotNull(Class eClass, IEntity entity) {
        Map<String, Object> where = entity.toColumnMap();
        MybatisUtil.assertNotEmpty("the property of entity can't be all empty.", where);
        List list = RefKit.mapper(eClass).listByMap(true, where);
        return (T)list;
    }

    private static <T> T firstByNotNull(Class eClass, IEntity entity) {
        Object query = RefKit.byEntity(eClass).query();
        ((BaseSegment)query.where().eqByEntity(entity, new String[0])).end();
        return query.limit(1).to().findOne().orElse(null);
    }

    private static <T> T logicDeleteById(Class eClass, IEntity entity) {
        RefKit.mapper(eClass).logicDeleteById(entity.findPk());
        return null;
    }

    private static <T> T deleteById(Class eClass, IEntity entity) {
        RefKit.mapper(eClass).deleteById(entity.findPk());
        return null;
    }

    private static <T> T findById(Class eClass, IEntity entity) {
        Object result = RefKit.mapper(eClass).findById(entity.findPk());
        return (T)result;
    }

    private static <T> T updateById(Class eClass, IEntity entity) {
        RefKit.mapper(eClass).updateById(entity);
        return (T)entity;
    }

    private static <T> T save(Class eClass, IEntity entity) {
        RefKit.mapper(eClass).save(entity);
        return (T)entity;
    }

    public static IRichMapper mapper(Class<? extends IEntity> eClass) {
        eClass = MybatisUtil.entityClass(eClass);
        IWrapperMapper mapper = (IWrapperMapper)RefKit.mapperByEntity(eClass.getName());
        mapper = PrinterMapper.get(mapper, eClass);
        return mapper;
    }

    public static Set<String> getEntityClass(Class<? extends IEntity>[] eClasses) {
        if (If.isEmpty(eClasses)) {
            return RefKit.allEntityClass();
        }
        return Stream.of(eClasses).map(Class::getName).collect(Collectors.toSet());
    }

    public static <E> void put(Class<E> eClass, String refName, IGetter<List<E>> finder) {
        String name = LambdaUtil.resolve(finder);
        relations.put(name, new RefFinder<E>(eClass, refName, finder));
    }

    public static <E extends IEntity> void put(IGetter<E> finder) {
        String name = LambdaUtil.resolve(finder);
        relations.put(name, finder);
    }

    public static FluentMybatisException notFluentMybatisEntity(Class eClass) {
        return new FluentMybatisException("the class[" + eClass.getName() + "] is not a @FluentMybatis Entity or it's sub class.");
    }

    public static FluentMybatisException notFluentMybatisEntity(String eClass) {
        return new FluentMybatisException("the class[" + eClass + "] is not a @FluentMybatis Entity or it's sub class.");
    }

    public static FluentMybatisException notFluentMybatisMapper(String mapperClass) {
        return new FluentMybatisException("the class[" + mapperClass + "] is not a fluent mybatis Mapper bean.");
    }
}

