/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.utility;

import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.crud.IQuery;
import cn.org.atool.fluent.mybatis.base.intf.IToMap;
import cn.org.atool.fluent.mybatis.exception.FluentMybatisException;
import cn.org.atool.fluent.mybatis.functions.MapFunction;
import cn.org.atool.fluent.mybatis.metadata.SetterMeta;
import cn.org.atool.fluent.mybatis.segment.model.PagedOffset;
import cn.org.atool.fluent.mybatis.typehandler.ConvertorKit;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;

public class PoJoHelper {
    public static <POJO> List<POJO> toPoJoList(List<Map<String, Object>> list, MapFunction<POJO> converter) {
        return list == null ? null : list.stream().map(map -> PoJoHelper.toPoJo(map, converter)).collect(Collectors.toList());
    }

    public static <POJO> POJO toPoJo(Map<String, Object> map, @NonNull MapFunction converter) {
        if (converter == null) {
            throw new NullPointerException("converter is marked non-null but is null");
        }
        return map == null ? null : (POJO)converter.apply(map);
    }

    public static <POJO> List<POJO> toPoJoList(Class<POJO> clazz, List<Map<String, Object>> list) {
        return list == null ? null : list.stream().map(map -> PoJoHelper.toPoJo(clazz, map)).collect(Collectors.toList());
    }

    public static <POJO> List<POJO> toPoJoListIgnoreNotFound(Class<POJO> clazz, List<Map<String, Object>> list) {
        return list == null ? null : list.stream().map(map -> PoJoHelper.toPoJoIgnoreNotFound(clazz, map)).collect(Collectors.toList());
    }

    public static <POJO> POJO toPoJo(@NonNull Class<POJO> clazz, @NonNull Map<String, Object> map) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        return PoJoHelper.toPoJo(clazz, map, false);
    }

    public static <POJO> POJO toPoJoIgnoreNotFound(@NonNull Class<POJO> clazz, @NonNull Map<String, Object> map) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        return PoJoHelper.toPoJo(clazz, map, true);
    }

    private static <POJO> POJO toPoJo(@NonNull Class<POJO> klass, @NonNull Map<String, Object> map, boolean ignoreNotFound) {
        if (klass == null) {
            throw new NullPointerException("klass is marked non-null but is null");
        }
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        POJO target = PoJoHelper.newInstance(klass);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String name = MybatisUtil.underlineToCamel(entry.getKey(), false);
            SetterMeta meta = SetterMeta.get(klass, name);
            if (meta == null) {
                if (ignoreNotFound) continue;
                throw new RuntimeException("property[" + name + "] of class[" + klass.getName() + "] not found.");
            }
            try {
                Object value = entry.getValue();
                if (value == null) continue;
                Object _value = ConvertorKit.convertValueToType(value, meta.fType);
                meta.setValue(target, _value);
            }
            catch (Exception e) {
                String err = String.format("convert map to object[class=%s, property=%s, type=%s] error: %s", klass.getName(), name, meta.fType.toString(), e.getMessage());
                throw new RuntimeException(err, e);
            }
        }
        return target;
    }

    private static <POJO> POJO newInstance(Class<POJO> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("convert map to object[type=" + clazz.getName() + "] error: " + e.getMessage(), e);
        }
    }

    public static Map toMap(Object object) {
        MybatisUtil.assertNotNull("object", object);
        if (object instanceof IEntity) {
            return ((IEntity)object).toEntityMap();
        }
        if (object instanceof Map) {
            return new HashMap((Map)object);
        }
        if (object instanceof IToMap) {
            return ((IToMap)object).toMap();
        }
        return IToMap.toMap(object);
    }

    public static int validateTagPaged(IQuery query) {
        PagedOffset paged = query.data().paged();
        if (paged == null) {
            throw new FluentMybatisException("Paged parameter not set");
        }
        if (paged.getOffset() != 0) {
            throw new FluentMybatisException("The offset of TagList should from zero, please use method: limit(size) or limit(0, size) .");
        }
        return paged.getLimit();
    }

    public static <T> Object[] getFields(List<T> list, Function<T, Object> getFunc) {
        return list.stream().map(getFunc).toArray(Object[]::new);
    }
}

