/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.typehandler;

import cn.org.atool.fluent.common.kits.KeyMap;
import cn.org.atool.fluent.mybatis.typehandler.IConvertor;
import cn.org.atool.fluent.mybatis.utility.ObjectArray;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.Date;

public class ConvertorKit {
    private static final KeyMap<IConvertor> convertors = new KeyMap();
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static Object convertValueToType(Object value, Type type) {
        if (value == null) {
            return null;
        }
        IConvertor convertor = ConvertorKit.findConvertor(type);
        if (convertor != null && convertor.match(value)) {
            return convertor.get(value);
        }
        if (type instanceof Class) {
            return ConvertorKit.convertValueToClass(value, (Class)type);
        }
        return value;
    }

    public static Object convertValueToClass(Object value, Class type) {
        if (type.isAssignableFrom(value.getClass())) {
            return value;
        }
        if (type == Long.class || type == Long.TYPE) {
            return Long.parseLong(value.toString());
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return Integer.parseInt(value.toString());
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return ObjectArray.toBoolean(value);
        }
        if (type == BigDecimal.class) {
            return new BigDecimal(value.toString());
        }
        if (type == BigInteger.class) {
            return new BigInteger(value.toString());
        }
        if (value instanceof Timestamp) {
            Timestamp t = (Timestamp)value;
            if (type == LocalDateTime.class) {
                return t.toLocalDateTime();
            }
            if (type == LocalDate.class) {
                return LocalDate.from(t.toInstant().atZone(ZoneOffset.systemDefault()));
            }
            if (type == LocalTime.class) {
                return LocalTime.from(t.toInstant().atZone(ZoneOffset.systemDefault()));
            }
            return value;
        }
        if (type.isEnum() && value instanceof String) {
            return Enum.valueOf(type, (String)value);
        }
        if (type == String.class) {
            return ConvertorKit.toString(value);
        }
        return value;
    }

    public static String toString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Date) {
            return sdf.format((Date)value);
        }
        return String.valueOf(value);
    }

    private static IConvertor findConvertor(Type type) {
        return (IConvertor)convertors.get(type.getTypeName());
    }

    public static void register(Type type, IConvertor convertor) {
        convertors.put(type.getTypeName(), (Object)convertor);
    }

    public static void register(String typeName, IConvertor convertor) {
        convertors.put(typeName, (Object)convertor);
    }
}

