/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.spring;

import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.intf.IRelation;
import cn.org.atool.fluent.mybatis.base.mapper.IEntityMapper;
import cn.org.atool.fluent.mybatis.functions.IExecutor;
import cn.org.atool.fluent.mybatis.functions.TableDynamic;
import cn.org.atool.fluent.mybatis.metadata.DbType;
import cn.org.atool.fluent.mybatis.spring.IMapperFactory;
import cn.org.atool.fluent.mybatis.typehandler.IConvertor;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import cn.org.atool.fluent.mybatis.utility.RefKit;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class MapperFactory
implements IMapperFactory {
    private static final Logger log = LoggerFactory.getLogger(MapperFactory.class);
    private ApplicationContext context;
    private static boolean isInitialized = false;
    private Collection<SqlSessionFactory> sessionFactories;
    private final List<IExecutor> initializers = new ArrayList<IExecutor>();

    @Autowired
    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
        this.sessionFactories = context.getBeansOfType(SqlSessionFactory.class).values();
        MybatisUtil.assertNotEmpty("SqlSessionFactory", this.sessionFactories);
        if (isInitialized) {
            return;
        }
        this.init();
        log.info(MybatisUtil.getVersionBanner());
        isInitialized = true;
    }

    public Set<IEntityMapper> getMappers() {
        Map mappers = this.context.getBeansOfType(IEntityMapper.class);
        return new HashSet<IEntityMapper>(mappers.values());
    }

    public Set<IRelation> getRelations() {
        Map relations = this.context.getBeansOfType(IRelation.class);
        return new HashSet<IRelation>(relations.values());
    }

    public MapperFactory dbType(DbType dbType, Class<? extends IEntity> ... eClasses) {
        return this.initializer(() -> RefKit.dbType(dbType, eClasses));
    }

    public MapperFactory tableSupplier(TableDynamic tableSupplier, Class<? extends IEntity> ... eClasses) {
        return this.initializer(() -> RefKit.tableSupplier(tableSupplier, eClasses));
    }

    public MapperFactory register(Type type, IConvertor convertor) {
        return this.initializer(() -> RefKit.register(type, convertor));
    }

    public MapperFactory register(String type, IConvertor convertor) {
        return this.initializer(() -> RefKit.register(type, convertor));
    }

    public MapperFactory initializer(IExecutor initializer) {
        this.initializers.add(initializer);
        return this;
    }

    public static void setMapUnderscoreToCamelCase(SqlSessionFactoryBean sqlSessionFactoryBean) {
        Configuration configuration = new Configuration();
        configuration.setLazyLoadingEnabled(true);
        configuration.setMapUnderscoreToCamelCase(true);
        sqlSessionFactoryBean.setConfiguration(configuration);
    }

    public static boolean isInitialized() {
        return isInitialized;
    }

    @Override
    public Collection<SqlSessionFactory> getSessionFactories() {
        return this.sessionFactories;
    }

    @Override
    public List<IExecutor> getInitializers() {
        return this.initializers;
    }
}

