/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.segment.model;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.base.crud.IQuery;
import cn.org.atool.fluent.mybatis.base.crud.IWrapper;
import cn.org.atool.fluent.mybatis.base.entity.IMapping;
import cn.org.atool.fluent.mybatis.base.intf.IDataByColumn;
import cn.org.atool.fluent.mybatis.base.model.ISqlOp;
import cn.org.atool.fluent.mybatis.base.model.SqlOp;
import cn.org.atool.fluent.mybatis.exception.FluentMybatisException;
import cn.org.atool.fluent.mybatis.mapper.MapperSql;
import cn.org.atool.fluent.mybatis.segment.BaseWrapper;
import cn.org.atool.fluent.mybatis.segment.fragment.BracketFrag;
import cn.org.atool.fluent.mybatis.segment.fragment.CachedFrag;
import cn.org.atool.fluent.mybatis.segment.fragment.Column;
import cn.org.atool.fluent.mybatis.segment.fragment.Fragments;
import cn.org.atool.fluent.mybatis.segment.fragment.IFragment;
import cn.org.atool.fluent.mybatis.segment.fragment.JoiningFrag;
import cn.org.atool.fluent.mybatis.segment.fragment.KeyFrag;
import cn.org.atool.fluent.mybatis.segment.model.HintType;
import cn.org.atool.fluent.mybatis.segment.model.IWrapperData;
import cn.org.atool.fluent.mybatis.segment.model.MergeSegments;
import cn.org.atool.fluent.mybatis.segment.model.PagedOffset;
import cn.org.atool.fluent.mybatis.segment.model.Parameters;
import cn.org.atool.fluent.mybatis.utility.CustomizedSql;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class WrapperData
implements IWrapperData,
IDataByColumn {
    protected final IWrapper wrapper;
    protected final Parameters parameters;
    protected boolean distinct = false;
    public final JoiningFrag select = JoiningFrag.get(", ").setFilter(If::notBlank);
    private final Map<IFragment, String> updates = new LinkedHashMap<IFragment, String>(16);
    private final Map<HintType, String> hints = new HashMap<HintType, String>(4);
    private final Set<String> fieldAlias = new HashSet<String>();
    private MergeSegments segments = new MergeSegments();
    protected PagedOffset paged;
    private boolean ignoreLockVersion = false;
    private CachedFrag customizedSql = Fragments.SEG_EMPTY;
    private final List<Union> unions = new ArrayList<Union>();
    private final Map<String, List<Object>> eqWhere = new HashMap<String, List<Object>>();

    public void replacedByQuery(IQuery query) {
        this.segments = query.data().segments();
        this.ignoreLockVersion = query.data().ignoreLockVersion;
        query.data().sharedParameter(this);
    }

    @Override
    public MergeSegments segments() {
        return this.segments;
    }

    public PagedOffset paged() {
        return this.paged;
    }

    public boolean ignoreVersion() {
        return this.ignoreLockVersion;
    }

    public WrapperData(IWrapper wrapper) {
        this(wrapper, new Parameters());
    }

    public WrapperData(IWrapper wrapper, Parameters parameters) {
        MybatisUtil.notNull(wrapper, "IQuery/IUpdate must not null!", new Object[0]);
        MybatisUtil.notNull(parameters, "Parameters must not null!", new Object[0]);
        this.wrapper = wrapper;
        this.parameters = parameters;
    }

    public IFragment table() {
        return m -> {
            String alias = this.wrapper.getTableAlias();
            String table = this.wrapper.table(true).get(m);
            return table + (If.isBlank(alias) ? "" : " " + alias);
        };
    }

    @Override
    public IFragment select() {
        if (this.select.isEmpty()) {
            Optional<IMapping> mapping = this.wrapper.mapping();
            return mapping.map(IMapping::getSelectAll).orElse(Fragments.SEG_ASTERISK);
        }
        return this.select;
    }

    public void union(String union, IQuery query) {
        this.unions.add(new Union(union, query));
    }

    public void customizedSql(String sql, Object parameter) {
        if (parameter == null) {
            this.customizedSql = CachedFrag.set(sql);
        } else {
            String newSql = CustomizedSql.rewriteSql(sql, this.parameters, parameter);
            this.customizedSql = CachedFrag.set(newSql);
        }
    }

    public IFragment wrappedByPaged(String sql) {
        PagedOffset paged = this.paged();
        if (paged == null) {
            return CachedFrag.set(sql);
        }
        return m -> {
            Parameters p = this.getParameters();
            String offset = p.putParameter(null, paged.getOffset());
            String size = p.putParameter(null, paged.getLimit());
            String endOffset = p.putParameter(null, paged.getEndOffset());
            return m.db().paged(sql, offset, size, endOffset);
        };
    }

    @Override
    public IFragment sql(boolean withPaged) {
        IFragment withoutPagedSegment = this.withoutPaged();
        IFragment withPagedSegment = this.withPaged(withPaged, withoutPagedSegment);
        return this.union(withPagedSegment);
    }

    private IFragment withPaged(boolean withPaged, IFragment withoutPaged) {
        if (!withPaged || this.paged == null) {
            return withoutPaged;
        }
        return m -> {
            Parameters p = this.getParameters();
            String offset = p.putParameter(null, this.paged.getOffset());
            String size = p.putParameter(null, this.paged.getLimit());
            String endOffset = p.putParameter(null, this.paged.getEndOffset());
            return m.db().paged(withoutPaged.get(m), offset, size, endOffset);
        };
    }

    private IFragment withoutPaged() {
        if (this.customizedSql.notEmpty()) {
            return this.customizedSql;
        }
        return m -> {
            MapperSql text = new MapperSql();
            text.SELECT(m, this.table(), this, this.select());
            text.WHERE_GROUP_ORDER_BY(m, this);
            return text.toString();
        };
    }

    private IFragment union(IFragment segment) {
        segment = this.unions.isEmpty() ? segment : BracketFrag.set(segment);
        for (Union union : this.unions) {
            segment = segment.plus(" " + union.key + " ").plus(BracketFrag.set(union.query));
        }
        return segment;
    }

    @Override
    public IFragment update() {
        return m -> this.updates.entrySet().stream().map(i -> ((IFragment)i.getKey()).get(m) + " = " + (String)i.getValue()).collect(Collectors.joining(", "));
    }

    @Override
    public <T> T valueByColumn(String column) {
        return (T)this.eqWhere.get(column);
    }

    public Class entityClass() {
        if (this.wrapper instanceof BaseWrapper) {
            return ((BaseWrapper)this.wrapper).getEntityClass();
        }
        return null;
    }

    private synchronized List<Object> getEqValues(String key) {
        if (!this.eqWhere.containsKey(key)) {
            this.eqWhere.put(key, new ArrayList());
        }
        return this.eqWhere.get(key);
    }

    public void addEqWhere(Map<String, List<Object>> values) {
        for (Map.Entry<String, List<Object>> entry : values.entrySet()) {
            this.getEqValues(entry.getKey()).addAll((Collection<Object>)entry.getValue());
        }
    }

    public void apply(KeyFrag keyWord, IFragment column, ISqlOp operator, Object ... paras) {
        this.apply(keyWord, column, operator, (String)null, paras);
        if (!(column instanceof Column)) {
            return;
        }
        if (operator == SqlOp.EQ || operator == SqlOp.IN) {
            Stream.of(paras).forEach(c -> this.getEqValues(((Column)column).column).add(c));
        }
    }

    public void select(String column) {
        if (If.notBlank(column)) {
            this.select.add(Column.set(this.wrapper, column));
            this.fieldAlias.addAll(MybatisUtil.parseAlias(column));
        }
    }

    public void select(IFragment column) {
        this.select.add(column);
    }

    public void apply(KeyFrag keyWord, IFragment column, ISqlOp operator, String format, Object ... args) {
        if (keyWord == null) {
            throw new FluentMybatisException("the first segment should be: 'AND', 'OR', 'GROUP BY', 'HAVING' or 'ORDER BY'");
        }
        IFragment value = operator.operator(column, this.getParameters(), format, args);
        this.segments().add(keyWord, column, value);
    }

    public void apply(KeyFrag keyWord, IFragment column, ISqlOp operator, IFragment format, Object ... args) {
        if (keyWord == null) {
            throw new FluentMybatisException("the first segment should be: 'AND', 'OR', 'GROUP BY', 'HAVING' or 'ORDER BY'");
        }
        IFragment segment = operator.operator(column, this.getParameters(), format, args);
        this.segments().add(keyWord, column, segment);
    }

    public void apply(KeyFrag keyWord, IFragment ... segments) {
        if (keyWord == null) {
            throw new FluentMybatisException("the first segment should be: 'AND', 'OR', 'GROUP BY', 'HAVING' or 'ORDER BY'");
        }
        this.segments().add(keyWord, segments);
    }

    public String paramSql(Column column, String functionSql, Object[] values) {
        return this.parameters.paramSql(column, functionSql, values);
    }

    public void updateSet(Column column, Object value) {
        this.updateSql(column, "?", value);
    }

    public void updateSql(Column column, String functionSql, Object ... values) {
        if (If.notBlank(functionSql)) {
            this.updates.put(column, this.paramSql(column, functionSql, values));
        }
    }

    public void hint(HintType type, String hint) {
        if (If.notBlank(hint)) {
            this.hints.put(type, hint);
        }
    }

    public String hint(HintType type) {
        String hint = this.hints.get((Object)type);
        return If.isBlank(hint) ? " " : " " + hint + " ";
    }

    public void sharedParameter(WrapperData data) {
        this.getParameters().sharedParameter(data.getParameters());
    }

    public void sharedParameter(Parameters parameters) {
        this.getParameters().sharedParameter(parameters);
    }

    public boolean hasGroupBy() {
        return !this.segments().groupBy.isEmpty();
    }

    public boolean hasNext(long total) {
        return this.paged() != null && total > (long)this.paged().getEndOffset();
    }

    public boolean hasSelect() {
        return !this.select.isEmpty();
    }

    public IWrapper getWrapper() {
        return this.wrapper;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public boolean isDistinct() {
        return this.distinct;
    }

    public JoiningFrag getSelect() {
        return this.select;
    }

    public Map<IFragment, String> getUpdates() {
        return this.updates;
    }

    public Map<HintType, String> getHints() {
        return this.hints;
    }

    public Set<String> getFieldAlias() {
        return this.fieldAlias;
    }

    public CachedFrag getCustomizedSql() {
        return this.customizedSql;
    }

    public List<Union> getUnions() {
        return this.unions;
    }

    public Map<String, List<Object>> getEqWhere() {
        return this.eqWhere;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public void setPaged(PagedOffset paged) {
        this.paged = paged;
    }

    public void setIgnoreLockVersion(boolean ignoreLockVersion) {
        this.ignoreLockVersion = ignoreLockVersion;
    }

    private static class Union {
        final String key;
        final IQuery query;

        Union(String key, IQuery query) {
            this.key = key;
            this.query = query;
        }
    }
}

