/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.segment;

import cn.org.atool.fluent.mybatis.base.crud.BaseQuery;
import cn.org.atool.fluent.mybatis.base.crud.IBaseQuery;
import cn.org.atool.fluent.mybatis.base.crud.IQuery;
import cn.org.atool.fluent.mybatis.base.model.ISqlOp;
import cn.org.atool.fluent.mybatis.base.model.SqlOp;
import cn.org.atool.fluent.mybatis.exception.FluentMybatisException;
import cn.org.atool.fluent.mybatis.functions.QFunction;
import cn.org.atool.fluent.mybatis.ifs.Ifs;
import cn.org.atool.fluent.mybatis.ifs.IfsPredicate;
import cn.org.atool.fluent.mybatis.mapper.SqlLike;
import cn.org.atool.fluent.mybatis.segment.BaseApply;
import cn.org.atool.fluent.mybatis.segment.BaseWrapper;
import cn.org.atool.fluent.mybatis.segment.WhereBase;
import cn.org.atool.fluent.mybatis.segment.fragment.AppendFlag;
import cn.org.atool.fluent.mybatis.segment.fragment.IFragment;
import cn.org.atool.fluent.mybatis.segment.where.BooleanWhere;
import cn.org.atool.fluent.mybatis.segment.where.NumericWhere;
import cn.org.atool.fluent.mybatis.segment.where.ObjectWhere;
import cn.org.atool.fluent.mybatis.segment.where.StringWhere;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import cn.org.atool.fluent.mybatis.utility.NestedQueryFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class WhereApply<WHERE extends WhereBase<WHERE, ?, NQ>, NQ extends IBaseQuery<?, NQ>>
extends BaseApply<WHERE, NQ>
implements ObjectWhere<WHERE, NQ>,
NumericWhere<WHERE, NQ>,
StringWhere<WHERE, NQ>,
BooleanWhere<WHERE, NQ> {
    public WhereApply(WHERE where) {
        super(where);
    }

    @Override
    public <O> WHERE apply(ISqlOp op, O ... args) {
        if (op.getArgSize() > 0) {
            MybatisUtil.assertNotEmpty(this.current().name, args);
            if (args.length != op.getArgSize()) {
                throw new FluentMybatisException(op.getArgSize() + " parameters are required, but " + args.length + " is passed in");
            }
            Stream.of(args).forEach(arg -> MybatisUtil.assertNotNull(this.current().name, arg));
        }
        if (op.getArgSize() == -1) {
            MybatisUtil.assertNotEmpty(this.current().name, args);
        }
        if (op == SqlOp.IN && args.length == 1) {
            Object value = args[0];
            if (value instanceof Collection) {
                Object[] arr = ((Collection)value).toArray();
                MybatisUtil.assertNotEmpty(this.current().name, arr);
                if (arr.length > 1) {
                    return ((WhereBase)this.segment).apply(this.column(), (ISqlOp)SqlOp.IN, arr);
                }
                value = arr[0];
            }
            return ((WhereBase)this.segment).apply(this.column(), (ISqlOp)SqlOp.EQ, value);
        }
        return ((WhereBase)this.segment).apply(this.column(), op, (Object[])args);
    }

    @Override
    public <T> WHERE apply(ISqlOp op, Ifs<T> ifs) {
        if (ifs == null) {
            return this.apply(op, (O[])new Object[]{null});
        }
        if (op.getArgSize() > 1) {
            throw new IllegalArgumentException("Ifs condition does not apply to the operation:" + op.name());
        }
        for (IfsPredicate predicate : ifs.predicates) {
            if (this.doIfs(op, predicate)) break;
        }
        return (WHERE)((WhereBase)this.segment);
    }

    private boolean doIfs(ISqlOp op, IfsPredicate predicate) {
        Object value = predicate.value(op);
        if (!predicate.predicate.test(value)) {
            return false;
        }
        this.apply(op, (O[])new Object[]{value});
        return true;
    }

    @Override
    public <O> WHERE apply(Predicate<Object[]> predicate, ISqlOp op, O ... args) {
        return (WHERE)(predicate.test(args) ? this.apply(op, args) : (WhereBase)this.segment);
    }

    @Override
    public WHERE like(String value, Predicate<String> when) {
        if (when.test(value)) {
            return this.apply((ISqlOp)SqlOp.LIKE, (O[])new String[]{SqlLike.like(value)});
        }
        return (WHERE)((WhereBase)this.segment);
    }

    @Override
    public WHERE like(String value, boolean condition) {
        if (condition) {
            return this.apply((ISqlOp)SqlOp.LIKE, (O[])new String[]{SqlLike.like(value)});
        }
        return (WHERE)((WhereBase)this.segment);
    }

    @Override
    public WHERE notLike(String value, Predicate<String> when) {
        if (when.test(value)) {
            return this.apply((ISqlOp)SqlOp.NOT_LIKE, (O[])new String[]{SqlLike.like(value)});
        }
        return (WHERE)((WhereBase)this.segment);
    }

    @Override
    public WHERE notLike(String value, boolean condition) {
        if (condition) {
            return this.apply((ISqlOp)SqlOp.NOT_LIKE, (O[])new String[]{SqlLike.like(value)});
        }
        return (WHERE)((WhereBase)this.segment);
    }

    @Override
    public WHERE startWith(String value, Predicate<String> when) {
        if (when.test(value)) {
            return this.apply((ISqlOp)SqlOp.LIKE, (O[])new String[]{SqlLike.left(value)});
        }
        return (WHERE)((WhereBase)this.segment);
    }

    @Override
    public WHERE startWith(String value, boolean condition) {
        if (condition) {
            return this.apply((ISqlOp)SqlOp.LIKE, (O[])new String[]{SqlLike.left(value)});
        }
        return (WHERE)((WhereBase)this.segment);
    }

    @Override
    @Deprecated
    public WHERE likeLeft(String value, Predicate<String> when) {
        if (when.test(value)) {
            return this.apply((ISqlOp)SqlOp.LIKE, (O[])new String[]{SqlLike.left(value)});
        }
        return (WHERE)((WhereBase)this.segment);
    }

    @Override
    @Deprecated
    public WHERE likeRight(String value, Predicate<String> when) {
        if (when.test(value)) {
            return this.apply((ISqlOp)SqlOp.LIKE, (O[])new String[]{SqlLike.right(value)});
        }
        return (WHERE)((WhereBase)this.segment);
    }

    @Override
    public WHERE endWith(String value, Predicate<String> when) {
        if (when.test(value)) {
            return this.apply((ISqlOp)SqlOp.LIKE, (O[])new String[]{SqlLike.right(value)});
        }
        return (WHERE)((WhereBase)this.segment);
    }

    @Override
    public WHERE endWith(String value, boolean condition) {
        if (condition) {
            return this.apply((ISqlOp)SqlOp.LIKE, (O[])new String[]{SqlLike.right(value)});
        }
        return (WHERE)((WhereBase)this.segment);
    }

    @Override
    public WHERE in(Collection values) {
        return this.apply((ISqlOp)SqlOp.IN, (O[])(values == null ? new Object[]{} : values.toArray()));
    }

    @Override
    public <O> WHERE in(String select, O ... args) {
        if (MybatisUtil.isCollection(args)) {
            return ((WhereBase)this.segment).apply(this.column(), (ISqlOp)SqlOp.IN, select, ((Collection)args[0]).toArray());
        }
        return ((WhereBase)this.segment).apply(this.column(), (ISqlOp)SqlOp.IN, select, (Object[])args);
    }

    @Override
    public <O> WHERE in(boolean condition, String select, O ... args) {
        return (WHERE)(condition ? this.in(select, args) : (WhereBase)this.segment);
    }

    @Override
    public WHERE in(QFunction<NQ> query) {
        Object nested = NestedQueryFactory.nested(((WhereBase)this.segment).wrapper, false);
        query.apply(nested);
        return this.in((IQuery)nested);
    }

    @Override
    public WHERE in(IQuery query) {
        ((BaseWrapper)((Object)query)).sharedParameter(((WhereBase)this.segment).getParameters());
        return ((WhereBase)this.segment).apply(this.column(), (ISqlOp)SqlOp.IN, query.data().sql(false), new Object[0]);
    }

    @Override
    public WHERE in(boolean condition, QFunction<NQ> query) {
        return (WHERE)(condition ? this.in(query) : (WhereBase)this.segment);
    }

    @Override
    public WHERE in(boolean condition, IQuery query) {
        return (WHERE)(condition ? this.in(query) : (WhereBase)this.segment);
    }

    @Override
    public WHERE notIn(QFunction<NQ> query) {
        Object nested = NestedQueryFactory.nested(((WhereBase)this.segment).wrapper, false);
        query.apply(nested);
        return this.notIn((IQuery)nested);
    }

    @Override
    public WHERE notIn(IQuery query) {
        ((BaseWrapper)((Object)query)).sharedParameter(((WhereBase)this.segment).getParameters());
        return ((WhereBase)this.segment).apply(this.column(), (ISqlOp)SqlOp.NOT_IN, query.data().sql(false), new Object[0]);
    }

    @Override
    public WHERE notIn(boolean condition, QFunction<NQ> query) {
        return (WHERE)(condition ? this.notIn(query) : (WhereBase)this.segment);
    }

    @Override
    public WHERE notIn(boolean condition, IQuery query) {
        return (WHERE)(condition ? this.notIn(query) : (WhereBase)this.segment);
    }

    @Override
    public WHERE apply(String opArgs) {
        return ((WhereBase)this.segment).apply(this.column(), (ISqlOp)SqlOp.RETAIN, opArgs, new Object[0]);
    }

    @Override
    public WHERE applyFunc(ISqlOp op, String expression, Object ... args) {
        int prev = 0;
        AppendFlag buff = new AppendFlag();
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object arg : args) {
            int next = expression.indexOf(63, prev);
            if (next < 0) {
                throw new IllegalArgumentException("The number of placeholders and parameters are not equal.");
            }
            buff.append(expression, prev, next);
            if (arg instanceof IQuery) {
                IFragment nest = ((IQuery)arg).data().sql(false);
                buff.append(nest);
                ((BaseQuery)arg).sharedParameter(((WhereBase)this.segment).wrapper);
            } else {
                buff.append(Character.valueOf('?'));
                list.add(arg);
            }
            prev = next + 1;
        }
        buff.append(expression, prev, expression.length());
        return ((WhereBase)this.segment).apply(this.column(), op, buff, list.toArray());
    }

    @Override
    public WHERE applyFunc(Predicate<Object[]> predicate, ISqlOp op, String expression, Object ... args) {
        if (predicate.test(args)) {
            this.apply(op, (O[])new Serializable[]{expression, args});
        }
        return ((WhereBase)this.segment).and;
    }
}

