/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.segment;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.base.crud.IBaseQuery;
import cn.org.atool.fluent.mybatis.base.crud.IWrapper;
import cn.org.atool.fluent.mybatis.base.model.FieldMapping;
import cn.org.atool.fluent.mybatis.functions.FieldPredicate;
import cn.org.atool.fluent.mybatis.functions.IAggregate;
import cn.org.atool.fluent.mybatis.functions.IGetter;
import cn.org.atool.fluent.mybatis.segment.AggregateSegment;
import cn.org.atool.fluent.mybatis.segment.fragment.Column;
import cn.org.atool.fluent.mybatis.segment.fragment.IFragment;
import cn.org.atool.fluent.mybatis.segment.fragment.JoiningFrag;
import cn.org.atool.fluent.mybatis.utility.LambdaUtil;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class SelectorBase<S extends SelectorBase<S, Q>, Q extends IBaseQuery<?, Q>>
extends AggregateSegment<S, Q, S> {
    private static final String AS = " AS ";

    protected SelectorBase(Q query) {
        super(query);
    }

    protected SelectorBase(S origin, IAggregate aggregate) {
        super(origin, aggregate);
    }

    public S apply(String column, String ... columns) {
        this.assertColumns(columns);
        this.applyAs(column, null);
        Stream.of(columns).forEach(c -> this.applyAs((String)c, null));
        return (S)((SelectorBase)super.getOrigin());
    }

    public S applyField(String field, String ... fields) {
        this.assertColumns(fields);
        this.applyColumn(this.aggregate, this.column(field), null);
        Stream.of(fields).forEach(c -> this.applyColumn(this.aggregate, this.column((String)c), null));
        return (S)((SelectorBase)super.getOrigin());
    }

    public S apply(FieldMapping column, FieldMapping ... columns) {
        this.assertColumns(columns);
        this.applyAs(column, null);
        Stream.of(columns).forEach(c -> this.applyAs((FieldMapping)c, null));
        return (S)((SelectorBase)super.getOrigin());
    }

    public <E> S apply(IGetter<E> getter, IGetter<E> ... getters) {
        this.assertColumns(getters);
        this.applyColumn(this.aggregate, this.column(LambdaUtil.resolveGetter(getter)), null);
        Stream.of(getters).forEach(c -> this.applyColumn(this.aggregate, this.column(LambdaUtil.resolveGetter(c)), null));
        return (S)((SelectorBase)super.getOrigin());
    }

    public S applyAs(String column, String alias) {
        return this.applyColumn(this.aggregate, Column.set((IWrapper)this.wrapper, column), alias);
    }

    public <E> S applyAs(IGetter<E> getter, String alias) {
        return this.applyColumn(this.aggregate, this.column(LambdaUtil.resolveGetter(getter)), alias);
    }

    public S applyFieldAs(String field, String alias) {
        return this.applyColumn(this.aggregate, this.column(field), alias);
    }

    public S applyAs(FieldMapping column, String alias) {
        return this.applyColumn(this.aggregate, Column.set((IWrapper)this.wrapper, column), alias);
    }

    public Q exclude(String ... columns) {
        this.assertColumns(columns);
        List<String> excludes = Arrays.asList(columns);
        IFragment seg = this.excludeSelect(excludes, true);
        this.data().select(seg);
        return (Q)((IBaseQuery)((Object)this.wrapper));
    }

    public Q excludeField(String ... columns) {
        this.assertColumns(columns);
        List<String> excludes = Arrays.asList(columns);
        IFragment seg = this.excludeSelect(excludes, false);
        this.data().select(seg);
        return (Q)((IBaseQuery)((Object)this.wrapper));
    }

    public <E> Q exclude(IGetter<E> ... columns) {
        this.assertColumns(columns);
        List<String> excludes = Stream.of(columns).map(LambdaUtil::resolveGetter).collect(Collectors.toList());
        IFragment seg = this.excludeSelect(excludes, false);
        this.data().select(seg);
        return (Q)((IBaseQuery)((Object)this.wrapper));
    }

    public Q exclude(FieldMapping ... columns) {
        this.assertColumns(columns);
        List<String> excludes = Stream.of(columns).map(f -> f.column).collect(Collectors.toList());
        IFragment seg = this.excludeSelect(excludes, true);
        this.data().select(seg);
        return (Q)((IBaseQuery)((Object)this.wrapper));
    }

    public S applyFunc(IAggregate func, String column, String alias) {
        return this.applyColumn(func, Column.set((IWrapper)this.wrapper, column), alias);
    }

    public S applyFuncByField(IAggregate func, String field, String alias) {
        return this.applyColumn(func, this.column(field), alias);
    }

    public <E> S applyFunc(IAggregate func, IGetter<E> getter, String alias) {
        return this.applyColumn(func, this.column(LambdaUtil.resolveGetter(getter)), alias);
    }

    public S applyFunc(IAggregate func, FieldMapping column, String alias) {
        return this.applyColumn(func, Column.set((IWrapper)this.wrapper, column), alias);
    }

    public S count(String alias) {
        return this.applyAs("COUNT(*)", alias);
    }

    public S apply(FieldPredicate predicate) {
        List<String> columns = this.wrapper.getTableMeta().filter(false, predicate);
        columns.forEach(x$0 -> this.apply((String)x$0, new String[0]));
        return (S)((SelectorBase)super.getOrigin());
    }

    @Override
    protected S apply() {
        return this.applyAs(this.current.column, null);
    }

    protected S process(FieldMapping field, String alias) {
        this.current = field;
        return this.applyAs(field, alias);
    }

    private IFragment excludeSelect(List<String> excludes, boolean byColumnName) {
        return m -> {
            JoiningFrag joining = new JoiningFrag(", ");
            for (FieldMapping f : m.allFields()) {
                if (byColumnName && excludes.contains(f.column) || !byColumnName && excludes.contains(f.name)) continue;
                joining.add(Column.set((IWrapper)this.wrapper, f));
            }
            return joining.get(m);
        };
    }

    private S applyColumn(IAggregate aggregate, IFragment column, String alias) {
        if (aggregate != null) {
            column = aggregate.aggregate(column);
        }
        if (If.notBlank(alias)) {
            this.data().getFieldAlias().add(alias);
            column = column.plus(AS).plus(alias);
        }
        this.data().select(column);
        return (S)((SelectorBase)super.getOrigin());
    }

    private IFragment column(String fieldName) {
        return m -> {
            FieldMapping f = m.getFieldsMap().get(fieldName);
            if (f == null) {
                throw new RuntimeException("Field[" + fieldName + "] of Entity[" + m.entityClass().getName() + "] not defined.");
            }
            return Column.set((IWrapper)this.wrapper, f).get(m);
        };
    }

    private void assertColumns(Object[] columns) {
        if (If.notEmpty(columns) && this.aggregate != null) {
            throw new RuntimeException("Aggregate functions allow only one apply column.");
        }
    }
}

