/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.segment;

import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.crud.IWrapper;
import cn.org.atool.fluent.mybatis.base.model.FieldMapping;
import cn.org.atool.fluent.mybatis.segment.BaseWrapper;
import cn.org.atool.fluent.mybatis.segment.model.WrapperData;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import cn.org.atool.fluent.mybatis.utility.RefKit;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;

public abstract class BaseSegment<R, W extends IWrapper<?, W, ?>> {
    protected final BaseWrapper wrapper;
    protected FieldMapping current;

    protected BaseSegment(W wrapper) {
        this.wrapper = (BaseWrapper)wrapper;
    }

    public R set(FieldMapping field) {
        this.current = field;
        return this.apply();
    }

    public FieldMapping get() {
        return this.current;
    }

    protected abstract R apply();

    public W end() {
        return (W)this.wrapper;
    }

    WrapperData data() {
        return this.wrapper.data();
    }

    protected void byEntity(IEntity entity, BiConsumer<String, Object> consumer, boolean allowPk, List<String> columns) {
        MybatisUtil.assertNotNull("entity", entity);
        Map<String, Object> map = entity.toColumnMap(true);
        String pk = RefKit.primaryId(entity.entityClass());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String column = entry.getKey();
            Object value = entry.getValue();
            if (Objects.equals(pk, column) && (!allowPk || value == null) || !columns.isEmpty() && !columns.contains(column) || columns.isEmpty() && value == null) continue;
            consumer.accept(column, value);
        }
    }

    protected void byExclude(IEntity entity, BiConsumer<String, Object> consumer, boolean allowPk, List<String> excludes) {
        MybatisUtil.assertNotNull("entity", entity);
        Map<String, Object> map = entity.toColumnMap(true);
        String pk = RefKit.primaryId(entity.entityClass());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String column = entry.getKey();
            Object value = entry.getValue();
            if (Objects.equals(pk, column) && (!allowPk || value == null) || !excludes.isEmpty() && excludes.contains(column)) continue;
            consumer.accept(column, entry.getValue());
        }
    }

    protected FieldMapping fieldMapping(String column) {
        return this.wrapper.column(column);
    }

    BaseWrapper getWrapper() {
        return this.wrapper;
    }
}

