/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.metadata;

import cn.org.atool.fluent.common.kits.KeyMap;
import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.annotation.FluentMybatis;
import cn.org.atool.fluent.mybatis.annotation.TableField;
import cn.org.atool.fluent.mybatis.annotation.TableId;
import cn.org.atool.fluent.mybatis.exception.FluentMybatisException;
import cn.org.atool.fluent.mybatis.metadata.TableFieldMeta;
import cn.org.atool.fluent.mybatis.metadata.TableMeta;
import cn.org.atool.fluent.mybatis.metadata.TablePrimaryMeta;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableMetaHelper {
    private static final Logger log = LoggerFactory.getLogger(TableMetaHelper.class);
    private static final KeyMap<TableMeta> TABLE_INFO_CACHE = new KeyMap();

    public static TableMeta getTableInfo(Class entityClass) {
        if (!TABLE_INFO_CACHE.containsKey((Type)entityClass)) {
            TableMetaHelper.initTableInfo(entityClass);
        }
        return (TableMeta)TABLE_INFO_CACHE.get((Type)entityClass);
    }

    static synchronized void initTableInfo(Class clazz) {
        if (!TABLE_INFO_CACHE.containsKey((Type)clazz)) {
            TableMeta tableMeta = new TableMeta(clazz);
            TableMetaHelper.initTableName(clazz, tableMeta);
            TableMetaHelper.initTableFields(clazz, tableMeta);
            TABLE_INFO_CACHE.put((Type)clazz, (Object)tableMeta);
        }
    }

    private static boolean initTableName(Class<?> clazz, TableMeta tableMeta) {
        FluentMybatis fluentMyBatis = clazz.getAnnotation(FluentMybatis.class);
        if (fluentMyBatis == null) {
            return false;
        }
        String tableName = fluentMyBatis.table();
        if (If.isBlank(tableName)) {
            tableName = MybatisUtil.tableName(clazz.getSimpleName(), fluentMyBatis.prefix(), fluentMyBatis.suffix());
        }
        tableMeta.setTableName(tableName);
        return true;
    }

    private static void initTableFields(Class clazz, TableMeta tableMeta) {
        List<Field> fields = MybatisUtil.getFieldList(clazz);
        ArrayList<TableFieldMeta> fieldList = new ArrayList<TableFieldMeta>();
        for (Field field : fields) {
            TableId tableId = field.getAnnotation(TableId.class);
            if (tableId == null) {
                TableField tableField = field.getAnnotation(TableField.class);
                fieldList.add(new TableFieldMeta(field, tableField));
                continue;
            }
            if (tableMeta.getPrimary() == null) {
                tableMeta.setPrimary(new TablePrimaryMeta(field, tableId));
                continue;
            }
            throw FluentMybatisException.instance("There must be only one, Discover multiple @TableId annotation in %s", clazz.getName());
        }
        Collections.sort(fieldList);
        tableMeta.setFields(Collections.unmodifiableList(fieldList));
        if (tableMeta.getPrimary() == null) {
            log.warn(String.format("Warn: Could not find @TableId in Class: %s.", clazz.getName()));
        }
    }
}

