/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.metadata;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.annotation.TableField;
import cn.org.atool.fluent.mybatis.metadata.FieldMeta;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import java.lang.reflect.Field;
import org.apache.ibatis.type.UnknownTypeHandler;

public class TableFieldMeta
extends FieldMeta {
    protected String numericScale;
    protected boolean notLarge = true;
    protected String update;
    protected String insert;

    public TableFieldMeta(Field field, TableField tableField) {
        super(tableField == null || If.isBlank(tableField.value()) ? MybatisUtil.camelToUnderline(field.getName(), false) : tableField.value(), field);
        if (tableField != null) {
            this.setJdbcType(tableField.jdbcType());
            this.numericScale = tableField.numericScale();
            this.typeHandler = UnknownTypeHandler.class == tableField.typeHandler() ? null : tableField.typeHandler();
            this.notLarge = tableField.notLarge();
            this.insert = tableField.insert();
            this.update = tableField.update();
        }
    }

    @Override
    protected String el() {
        String el = super.el();
        if (If.notBlank(this.numericScale)) {
            el = el + ", numericScale = " + this.numericScale;
        }
        return el;
    }

    public String getNumericScale() {
        return this.numericScale;
    }

    @Override
    public boolean isNotLarge() {
        return this.notLarge;
    }

    public String getUpdate() {
        return this.update;
    }

    public String getInsert() {
        return this.insert;
    }

    public String toString() {
        return "TableFieldMeta(numericScale=" + this.getNumericScale() + ", notLarge=" + this.isNotLarge() + ", update=" + this.getUpdate() + ", insert=" + this.getInsert() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableFieldMeta)) {
            return false;
        }
        TableFieldMeta other = (TableFieldMeta)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isNotLarge() != other.isNotLarge()) {
            return false;
        }
        String this$numericScale = this.getNumericScale();
        String other$numericScale = other.getNumericScale();
        if (this$numericScale == null ? other$numericScale != null : !this$numericScale.equals(other$numericScale)) {
            return false;
        }
        String this$update = this.getUpdate();
        String other$update = other.getUpdate();
        if (this$update == null ? other$update != null : !this$update.equals(other$update)) {
            return false;
        }
        String this$insert = this.getInsert();
        String other$insert = other.getInsert();
        return !(this$insert == null ? other$insert != null : !this$insert.equals(other$insert));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableFieldMeta;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isNotLarge() ? 79 : 97);
        String $numericScale = this.getNumericScale();
        result = result * 59 + ($numericScale == null ? 43 : $numericScale.hashCode());
        String $update = this.getUpdate();
        result = result * 59 + ($update == null ? 43 : $update.hashCode());
        String $insert = this.getInsert();
        result = result * 59 + ($insert == null ? 43 : $insert.hashCode());
        return result;
    }
}

