/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.metadata;

import cn.org.atool.fluent.common.kits.KeyMap;
import cn.org.atool.fluent.common.kits.SegmentLocks;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public class SetterMeta {
    private final String fieldName;
    private final Method method;
    public final Type fType;
    private static final KeyMap<KeyMap<SetterMeta>> methodMetas = new KeyMap();
    private static final SegmentLocks<Class> ClassLock = new SegmentLocks(16);

    private SetterMeta(Method method) {
        this.method = method;
        String name = method.getName();
        this.fieldName = name.substring(3, 4).toLowerCase() + name.substring(4);
        this.fType = method.getGenericParameterTypes()[0];
    }

    public void setValue(Object target, Object value) throws InvocationTargetException, IllegalAccessException {
        this.method.invoke(target, value);
    }

    public static SetterMeta get(Class klass, String fieldName) {
        ClassLock.lockDoing(arg_0 -> methodMetas.containsKey(arg_0), (Object)klass, () -> methodMetas.put((Type)klass, SetterMeta.buildMetas(klass)));
        return (SetterMeta)((KeyMap)methodMetas.get((Type)klass)).get(fieldName);
    }

    public static KeyMap<SetterMeta> get(Class klass) {
        ClassLock.lockDoing(arg_0 -> methodMetas.containsKey(arg_0), (Object)klass, () -> methodMetas.put((Type)klass, SetterMeta.buildMetas(klass)));
        return (KeyMap)methodMetas.get((Type)klass);
    }

    private static KeyMap<SetterMeta> buildMetas(Class klass) {
        KeyMap classMethods = new KeyMap();
        while (MybatisUtil.notBaseEntity(klass)) {
            for (Method m : klass.getDeclaredMethods()) {
                if (!m.getName().startsWith("set") || m.getParameterCount() != 1) continue;
                m.setAccessible(true);
                SetterMeta meta = new SetterMeta(m);
                classMethods.put(meta.fieldName, (Object)meta);
            }
            klass = klass.getSuperclass();
        }
        return classMethods;
    }
}

