/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.metadata;

import cn.org.atool.fluent.common.kits.KeyMap;
import cn.org.atool.fluent.common.kits.SegmentLocks;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public class GetterMeta {
    public final String fieldName;
    private final Method method;
    public final Type fType;
    private static final KeyMap<KeyMap<GetterMeta>> methodMetas = new KeyMap();
    private static final SegmentLocks<Class> ClassLock = new SegmentLocks(16);

    private GetterMeta(Method method) {
        this.method = method;
        String name = method.getName();
        this.fieldName = name.startsWith("is") ? name.substring(2, 3).toLowerCase() + name.substring(3) : name.substring(3, 4).toLowerCase() + name.substring(4);
        this.fType = method.getGenericReturnType();
    }

    public Object getValue(Object target) throws InvocationTargetException, IllegalAccessException {
        return target == null ? null : this.method.invoke(target, new Object[0]);
    }

    public static GetterMeta get(Class klass, String fieldName) {
        ClassLock.lockDoing(arg_0 -> methodMetas.containsKey(arg_0), (Object)klass, () -> methodMetas.put((Type)klass, GetterMeta.buildMetas(klass)));
        return (GetterMeta)((KeyMap)methodMetas.get((Type)klass)).get(fieldName);
    }

    public static KeyMap<GetterMeta> get(Class klass) {
        ClassLock.lockDoing(arg_0 -> methodMetas.containsKey(arg_0), (Object)klass, () -> methodMetas.put((Type)klass, GetterMeta.buildMetas(klass)));
        return (KeyMap)methodMetas.get((Type)klass);
    }

    private static KeyMap<GetterMeta> buildMetas(Class klass) {
        KeyMap classMethods = new KeyMap();
        while (MybatisUtil.notBaseEntity(klass)) {
            for (Method m : klass.getDeclaredMethods()) {
                String name = m.getName();
                if (!name.startsWith("get") && !name.startsWith("is") || m.getParameterCount() != 0) continue;
                m.setAccessible(true);
                GetterMeta meta = new GetterMeta(m);
                classMethods.put(meta.fieldName, (Object)meta);
            }
            klass = klass.getSuperclass();
        }
        return classMethods;
    }
}

