/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.ifs;

import cn.org.atool.fluent.mybatis.base.model.ISqlOp;
import cn.org.atool.fluent.mybatis.base.model.SqlOp;
import cn.org.atool.fluent.mybatis.utility.ObjectArray;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class IfsPredicate {
    public final Predicate predicate;
    private final Object[] values;

    public IfsPredicate(Predicate predicate, Object ... values) {
        this.predicate = predicate;
        this.values = this.convert(values);
    }

    private Object[] convert(Object[] values) {
        if (values == null || values.length != 1) {
            return values;
        }
        Object first = values[0];
        if (first == null) {
            return values;
        }
        if (first.getClass().isArray()) {
            return ObjectArray.array(first);
        }
        return values;
    }

    public Object value(ISqlOp op) {
        if (op == null || this.values == null) {
            return this.firstValue();
        }
        if (SqlOp.IN.equals(op)) {
            return Arrays.stream(this.values).collect(Collectors.toList());
        }
        return this.firstValue();
    }

    private Object firstValue() {
        return this.values == null || this.values.length == 0 ? null : this.values[0];
    }
}

