/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.base.provider;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.base.entity.IMapping;
import cn.org.atool.fluent.mybatis.base.entity.TableId;
import cn.org.atool.fluent.mybatis.base.model.FieldMapping;
import cn.org.atool.fluent.mybatis.base.provider.SqlKitFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.NoKeyGenerator;
import org.apache.ibatis.executor.keygen.SelectKeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultFlag;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.mapping.StatementType;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;

public class StatementBuilder
extends MappedStatement.Builder {
    private final String id;
    private final Configuration configuration;
    private final IMapping mapping;
    private final MappedStatement statement;
    private final TypeHandlerRegistry typeHandlerRegistry;

    public StatementBuilder(IMapping mapping, MappedStatement statement) {
        super(statement.getConfiguration(), statement.getId(), statement.getSqlSource(), statement.getSqlCommandType());
        this.mapping = mapping;
        this.id = statement.getId();
        this.statement = statement;
        this.configuration = statement.getConfiguration();
        this.typeHandlerRegistry = this.configuration.getTypeHandlerRegistry();
        this.resource(statement.getResource()).fetchSize(statement.getFetchSize()).timeout(statement.getTimeout()).statementType(statement.getStatementType()).keyGenerator(statement.getKeyGenerator()).keyProperty(this.joining(statement.getKeyProperties())).keyColumn(this.joining(statement.getKeyColumns())).databaseId(statement.getDatabaseId()).lang(statement.getLang()).resultOrdered(statement.isResultOrdered()).resultSets(this.joining(statement.getResultSets())).resultMaps(statement.getResultMaps()).resultSetType(statement.getResultSetType()).flushCacheRequired(statement.isFlushCacheRequired()).useCache(statement.isUseCache()).parameterMap(statement.getParameterMap()).cache(statement.getCache());
    }

    public MappedStatement selectKeyStatementOfInsert() {
        FieldMapping primary = this.mapping.primaryMapping();
        TableId tableId = this.mapping.tableId();
        KeyGenerator keyGenerator = SqlKitFactory.factory(this.mapping).insert(this, primary, tableId);
        this.keyProperty(primary.name);
        this.keyColumn(primary.column);
        this.keyGenerator(keyGenerator);
        return this.build();
    }

    public MappedStatement selectKeyStatementOfBatchInsert() {
        FieldMapping primary = this.mapping.primaryMapping();
        TableId tableId = this.mapping.tableId();
        KeyGenerator keyGenerator = SqlKitFactory.factory(this.mapping).insertBatch(this.mapping, this, primary, tableId);
        this.keyProperty(primary.name);
        this.keyColumn(primary.column);
        this.keyGenerator(keyGenerator);
        return this.build();
    }

    public MappedStatement listEntityStatement() {
        ArrayList<ResultMapping> resultMappings = new ArrayList<ResultMapping>();
        for (FieldMapping f : this.mapping.allFields()) {
            resultMappings.add(this.resultMapping(f));
        }
        Class type = this.mapping.entityClass();
        this.resultMaps(this.statementResultMaps(type.getName() + "-RM", type, resultMappings));
        return this.build();
    }

    public KeyGenerator handleSelectKey(FieldMapping primary, TableId tableId) {
        String selectId = this.id + "!selectKey";
        boolean executeBefore = this.mapping.db().feature.isBefore();
        String seqName = this.mapping.db().feature.getSeq();
        if (If.notBlank(tableId.seqName)) {
            seqName = tableId.seqName;
            executeBefore = tableId.isSeqBefore(this.mapping.db());
        }
        if (If.isBlank(seqName)) {
            return NoKeyGenerator.INSTANCE;
        }
        SqlSource sqlSource = this.statement.getLang().createSqlSource(this.configuration, seqName.trim(), primary.javaType);
        MappedStatement.Builder statementBuilder = new MappedStatement.Builder(this.configuration, selectId, sqlSource, SqlCommandType.SELECT).resource(this.statement.getResource()).fetchSize(null).timeout(null).statementType(StatementType.PREPARED).keyGenerator((KeyGenerator)NoKeyGenerator.INSTANCE).keyProperty("ew." + primary.name).keyColumn(primary.column).databaseId(this.statement.getDatabaseId()).lang(this.statement.getLang()).resultOrdered(false).resultSets(null).resultMaps(this.statementResultMaps(selectId + "-Inline", primary.javaType, new ArrayList<ResultMapping>())).resultSetType(null).flushCacheRequired(false).useCache(false).cache(this.statement.getCache());
        this.configuration.addMappedStatement(statementBuilder.build());
        MappedStatement keyStatement = this.configuration.getMappedStatement(selectId, false);
        SelectKeyGenerator keyGenerator = new SelectKeyGenerator(keyStatement, executeBefore);
        this.configuration.addKeyGenerator(selectId, (KeyGenerator)keyGenerator);
        return keyGenerator;
    }

    private ResultMapping resultMapping(FieldMapping field) {
        ArrayList<ResultFlag> flags = new ArrayList<ResultFlag>();
        if (field.isPrimary()) {
            flags.add(ResultFlag.ID);
        }
        return new ResultMapping.Builder(this.configuration, field.name, field.column, field.javaType).typeHandler(this.resolveTypeHandler(field.javaType, field.typeHandler)).flags(flags).build();
    }

    private TypeHandler<?> resolveTypeHandler(Class<?> javaType, Class<? extends TypeHandler<?>> typeHandlerType) {
        if (typeHandlerType == null) {
            return null;
        }
        TypeHandler handler = this.typeHandlerRegistry.getMappingTypeHandler(typeHandlerType);
        if (handler == null) {
            handler = this.typeHandlerRegistry.getInstance(javaType, typeHandlerType);
        }
        return handler;
    }

    private List<ResultMap> statementResultMaps(String statementId, Class<?> resultType, List<ResultMapping> resultMappings) {
        ArrayList<ResultMap> resultMaps = new ArrayList<ResultMap>();
        ResultMap resultMap = new ResultMap.Builder(this.configuration, statementId, resultType, resultMappings, null).build();
        resultMaps.add(resultMap);
        return resultMaps;
    }

    private String joining(String[] arr) {
        return arr == null ? null : String.join((CharSequence)",", arr);
    }
}

